/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.ErrorCodeSupplier;
import com.facebook.presto.jdbc.internal.spi.PrestoException;
import com.facebook.presto.jdbc.internal.spi.StandardErrorCode;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.type.AbstractIntType;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignature;

public final class RealType
extends AbstractIntType {
    public static final RealType REAL = new RealType();

    private RealType() {
        super(TypeSignature.parseTypeSignature("real"));
    }

    @Override
    public Object getObjectValue(ConnectorSession session, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return Float.valueOf(Float.intBitsToFloat(block.getInt(position, 0)));
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        float rightValue;
        float leftValue = Float.intBitsToFloat(leftBlock.getInt(leftPosition, 0));
        return leftValue == (rightValue = Float.intBitsToFloat(rightBlock.getInt(rightPosition, 0)));
    }

    @Override
    public long hash(Block block, int position) {
        return RealType.hash(Float.floatToIntBits(Float.intBitsToFloat(block.getInt(position, 0))));
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        float leftValue = Float.intBitsToFloat(leftBlock.getInt(leftPosition, 0));
        float rightValue = Float.intBitsToFloat(rightBlock.getInt(rightPosition, 0));
        return Float.compare(leftValue, rightValue);
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        try {
            Math.toIntExact(value);
        }
        catch (ArithmeticException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("Value (%sb) is not a valid single-precision float", Long.toBinaryString(value).replace(' ', '0')));
        }
        blockBuilder.writeInt((int)value).closeEntry();
    }

    @Override
    public boolean equals(Object other) {
        return other == REAL;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

