/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.javax.annotation.Nullable;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import com.facebook.presto.jdbc.internal.spi.block.IntArrayList;
import com.facebook.presto.jdbc.internal.spi.block.MapBlock;
import com.facebook.presto.jdbc.internal.spi.block.SingleMapBlock;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;

public abstract class AbstractMapBlock
implements Block {
    static final int HASH_MULTIPLIER = 2;
    protected final Type keyType;
    protected final MethodHandle keyNativeHashCode;
    protected final MethodHandle keyBlockNativeEquals;
    protected final MethodHandle keyBlockHashCode;

    public AbstractMapBlock(Type keyType, MethodHandle keyNativeHashCode, MethodHandle keyBlockNativeEquals, MethodHandle keyBlockHashCode) {
        this.keyType = Objects.requireNonNull(keyType, "keyType is null");
        this.keyNativeHashCode = keyNativeHashCode;
        this.keyBlockNativeEquals = keyBlockNativeEquals;
        this.keyBlockHashCode = Objects.requireNonNull(keyBlockHashCode, "keyBlockHashCode is null");
    }

    protected abstract Block getRawKeyBlock();

    protected abstract Block getRawValueBlock();

    @Nullable
    protected abstract int[] getHashTables();

    protected abstract int[] getOffsets();

    protected abstract int getOffsetBase();

    protected abstract boolean[] getMapIsNull();

    protected abstract void ensureHashTableLoaded();

    int getOffset(int position) {
        return this.getOffsets()[position + this.getOffsetBase()];
    }

    @Override
    public String getEncodingName() {
        return "MAP";
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        int[] newOffsets = new int[length + 1];
        boolean[] newMapIsNull = new boolean[length];
        IntArrayList entriesPositions = new IntArrayList();
        int newPosition = 0;
        for (int i = offset; i < offset + length; ++i) {
            int position = positions[i];
            if (this.isNull(position)) {
                newMapIsNull[newPosition] = true;
                newOffsets[newPosition + 1] = newOffsets[newPosition];
            } else {
                int entriesStartOffset = this.getOffset(position);
                int entriesEndOffset = this.getOffset(position + 1);
                int entryCount = entriesEndOffset - entriesStartOffset;
                newOffsets[newPosition + 1] = newOffsets[newPosition] + entryCount;
                for (int elementIndex = entriesStartOffset; elementIndex < entriesEndOffset; ++elementIndex) {
                    entriesPositions.add(elementIndex);
                }
            }
            ++newPosition;
        }
        int[] hashTable = this.getHashTables();
        int[] newHashTable = null;
        if (hashTable != null) {
            newHashTable = new int[newOffsets[newOffsets.length - 1] * 2];
            int newHashIndex = 0;
            for (int i = offset; i < offset + length; ++i) {
                int position = positions[i];
                int entriesStartOffset = this.getOffset(position);
                int entriesEndOffset = this.getOffset(position + 1);
                for (int hashIndex = entriesStartOffset * 2; hashIndex < entriesEndOffset * 2; ++hashIndex) {
                    newHashTable[newHashIndex] = hashTable[hashIndex];
                    ++newHashIndex;
                }
            }
        }
        Block newKeys = this.getRawKeyBlock().copyPositions(entriesPositions.elements(), 0, entriesPositions.size());
        Block newValues = this.getRawValueBlock().copyPositions(entriesPositions.elements(), 0, entriesPositions.size());
        return MapBlock.createMapBlockInternal(0, length, Optional.of(newMapIsNull), newOffsets, newKeys, newValues, Optional.ofNullable(newHashTable), this.keyType, this.keyBlockNativeEquals, this.keyNativeHashCode, this.keyBlockHashCode);
    }

    @Override
    public Block getRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        return MapBlock.createMapBlockInternal(position + this.getOffsetBase(), length, Optional.ofNullable(this.getMapIsNull()), this.getOffsets(), this.getRawKeyBlock(), this.getRawValueBlock(), Optional.ofNullable(this.getHashTables()), this.keyType, this.keyBlockNativeEquals, this.keyNativeHashCode, this.keyBlockHashCode);
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int entriesStart = this.getOffsets()[this.getOffsetBase() + position];
        int entriesEnd = this.getOffsets()[this.getOffsetBase() + position + length];
        int entryCount = entriesEnd - entriesStart;
        return this.getRawKeyBlock().getRegionSizeInBytes(entriesStart, entryCount) + this.getRawValueBlock().getRegionSizeInBytes(entriesStart, entryCount) + 5L * (long)length + 8L * (long)entryCount;
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidPositions(positions, positionCount);
        boolean[] entryPositions = new boolean[this.getRawKeyBlock().getPositionCount()];
        int usedEntryCount = 0;
        int usedPositionCount = 0;
        for (int i = 0; i < positions.length; ++i) {
            if (!positions[i]) continue;
            ++usedPositionCount;
            int entriesStart = this.getOffsets()[this.getOffsetBase() + i];
            int entriesEnd = this.getOffsets()[this.getOffsetBase() + i + 1];
            for (int j = entriesStart; j < entriesEnd; ++j) {
                entryPositions[j] = true;
            }
            usedEntryCount += entriesEnd - entriesStart;
        }
        return this.getRawKeyBlock().getPositionsSizeInBytes(entryPositions) + this.getRawValueBlock().getPositionsSizeInBytes(entryPositions) + 5L * (long)usedPositionCount + 8L * (long)usedEntryCount;
    }

    @Override
    public Block copyRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + length);
        Block newKeys = this.getRawKeyBlock().copyRegion(startValueOffset, endValueOffset - startValueOffset);
        Block newValues = this.getRawValueBlock().copyRegion(startValueOffset, endValueOffset - startValueOffset);
        int[] newOffsets = BlockUtil.compactOffsets(this.getOffsets(), position + this.getOffsetBase(), length);
        boolean[] mapIsNull = this.getMapIsNull();
        boolean[] newMapIsNull = mapIsNull == null ? null : BlockUtil.compactArray(mapIsNull, position + this.getOffsetBase(), length);
        int[] hashTables = this.getHashTables();
        int[] newHashTable = null;
        if (hashTables != null) {
            newHashTable = BlockUtil.compactArray(hashTables, startValueOffset * 2, (endValueOffset - startValueOffset) * 2);
        }
        if (newKeys == this.getRawKeyBlock() && newValues == this.getRawValueBlock() && newOffsets == this.getOffsets() && newMapIsNull == mapIsNull && newHashTable == this.getHashTables()) {
            return this;
        }
        return MapBlock.createMapBlockInternal(0, length, Optional.ofNullable(newMapIsNull), newOffsets, newKeys, newValues, Optional.ofNullable(newHashTable), this.keyType, this.keyBlockNativeEquals, this.keyNativeHashCode, this.keyBlockHashCode);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        if (clazz != Block.class) {
            throw new IllegalArgumentException("clazz must be Block.class");
        }
        this.checkReadablePosition(position);
        int startEntryOffset = this.getOffset(position);
        int endEntryOffset = this.getOffset(position + 1);
        return clazz.cast(new SingleMapBlock(startEntryOffset * 2, (endEntryOffset - startEntryOffset) * 2, this));
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        blockBuilder.appendStructureInternal(this, position);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        int valueLength = endValueOffset - startValueOffset;
        Block newKeys = this.getRawKeyBlock().copyRegion(startValueOffset, valueLength);
        Block newValues = this.getRawValueBlock().copyRegion(startValueOffset, valueLength);
        int[] hashTables = this.getHashTables();
        int[] newHashTable = null;
        if (hashTables != null) {
            newHashTable = Arrays.copyOfRange(hashTables, startValueOffset * 2, endValueOffset * 2);
        }
        return MapBlock.createMapBlockInternal(0, 1, Optional.of(new boolean[]{this.isNull(position)}), new int[]{0, valueLength}, newKeys, newValues, Optional.ofNullable(newHashTable), this.keyType, this.keyBlockNativeEquals, this.keyNativeHashCode, this.keyBlockHashCode);
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        this.checkReadablePosition(position);
        if (this.isNull(position)) {
            return 0L;
        }
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        long size = 0L;
        Block rawKeyBlock = this.getRawKeyBlock();
        Block rawValueBlock = this.getRawValueBlock();
        for (int i = startValueOffset; i < endValueOffset; ++i) {
            size += rawKeyBlock.getEstimatedDataSizeForStats(i);
            size += rawValueBlock.getEstimatedDataSizeForStats(i);
        }
        return size;
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        boolean[] mapIsNull = this.getMapIsNull();
        return mapIsNull != null && mapIsNull[position + this.getOffsetBase()];
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }
}

