/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.connector;

import com.facebook.presto.jdbc.internal.spi.BucketFunction;
import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.ConnectorSplit;
import com.facebook.presto.jdbc.internal.spi.Node;
import com.facebook.presto.jdbc.internal.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.jdbc.internal.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.jdbc.internal.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.jdbc.internal.spi.connector.NotPartitionedPartitionHandle;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.ToIntFunction;

public interface ConnectorNodePartitioningProvider {
    default public List<ConnectorPartitionHandle> listPartitionHandles(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return Collections.singletonList(NotPartitionedPartitionHandle.NOT_PARTITIONED);
    }

    public ConnectorBucketNodeMap getBucketNodeMap(ConnectorTransactionHandle var1, ConnectorSession var2, ConnectorPartitioningHandle var3);

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle var1, ConnectorSession var2, ConnectorPartitioningHandle var3);

    public BucketFunction getBucketFunction(ConnectorTransactionHandle var1, ConnectorSession var2, ConnectorPartitioningHandle var3, List<Type> var4, int var5);

    public static final class ConnectorBucketNodeMap {
        private final int bucketCount;
        private final Optional<Map<Integer, Node>> bucketToNode;

        public static ConnectorBucketNodeMap createBucketNodeMap(int bucketCount) {
            return new ConnectorBucketNodeMap(bucketCount, Optional.empty());
        }

        public static ConnectorBucketNodeMap createBucketNodeMap(Map<Integer, Node> bucketToNode) {
            Objects.requireNonNull(bucketToNode, "bucketToNode is null");
            if (bucketToNode.isEmpty()) {
                throw new IllegalArgumentException("bucketToNode is empty");
            }
            return new ConnectorBucketNodeMap(bucketToNode.keySet().stream().mapToInt(Integer::intValue).max().getAsInt() + 1, Optional.of(bucketToNode));
        }

        private ConnectorBucketNodeMap(int bucketCount, Optional<Map<Integer, Node>> bucketToNode) {
            if (bucketCount <= 0) {
                throw new IllegalArgumentException("bucketCount must be positive");
            }
            if (bucketToNode.isPresent() && bucketToNode.get().size() != bucketCount) {
                throw new IllegalArgumentException(String.format("Mismatched bucket count in bucketToNode (%s) and bucketCount (%s)", bucketToNode.get().size(), bucketCount));
            }
            this.bucketCount = bucketCount;
            this.bucketToNode = Objects.requireNonNull(bucketToNode, "bucketToNode is null").map(mapping -> Collections.unmodifiableMap(new HashMap(mapping)));
        }

        public int getBucketCount() {
            return this.bucketCount;
        }

        public boolean hasFixedMapping() {
            return this.bucketToNode.isPresent();
        }

        public Map<Integer, Node> getFixedMapping() {
            return this.bucketToNode.orElseThrow(() -> new IllegalArgumentException("No fixed bucket to node mapping"));
        }
    }
}

