/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractSingleArrayBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import java.util.function.BiConsumer;

public class SingleArrayBlockWriter
extends AbstractSingleArrayBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleArrayBlockWriter.class).instanceSize();
    private final BlockBuilder blockBuilder;
    private final long initialBlockBuilderSize;
    private int positionsWritten;

    public SingleArrayBlockWriter(BlockBuilder blockBuilder, int start) {
        super(start);
        this.blockBuilder = blockBuilder;
        this.initialBlockBuilderSize = blockBuilder.getSizeInBytes();
    }

    @Override
    protected Block getBlock() {
        return this.blockBuilder;
    }

    @Override
    public long getSizeInBytes() {
        return this.blockBuilder.getSizeInBytes() - this.initialBlockBuilderSize;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.blockBuilder.getRetainedSizeInBytes();
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.blockBuilder, this.blockBuilder.getRetainedSizeInBytes());
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public BlockBuilder writeByte(int value) {
        this.blockBuilder.writeByte(value);
        return this;
    }

    @Override
    public BlockBuilder writeShort(int value) {
        this.blockBuilder.writeShort(value);
        return this;
    }

    @Override
    public BlockBuilder writeInt(int value) {
        this.blockBuilder.writeInt(value);
        return this;
    }

    @Override
    public BlockBuilder writeLong(long value) {
        this.blockBuilder.writeLong(value);
        return this;
    }

    @Override
    public BlockBuilder writeBytes(Slice source, int sourceIndex, int length) {
        this.blockBuilder.writeBytes(source, sourceIndex, length);
        return this;
    }

    @Override
    public BlockBuilder appendStructure(Block block) {
        this.blockBuilder.appendStructure(block);
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder appendStructureInternal(Block block, int position) {
        this.blockBuilder.appendStructureInternal(block, position);
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder beginBlockEntry() {
        return this.blockBuilder.beginBlockEntry();
    }

    @Override
    public BlockBuilder appendNull() {
        this.blockBuilder.appendNull();
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        this.blockBuilder.closeEntry();
        this.entryAdded();
        return this;
    }

    private void entryAdded() {
        ++this.positionsWritten;
    }

    @Override
    public int getPositionCount() {
        return this.positionsWritten;
    }

    @Override
    public Block build() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return String.format("SingleArrayBlockWriter{positionCount=%d}", this.getPositionCount());
    }
}

