/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;

public abstract class AbstractSingleMapBlock
implements Block {
    abstract int getOffset();

    abstract Block getRawKeyBlock();

    abstract Block getRawValueBlock();

    private int getAbsolutePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
        return position + this.getOffset();
    }

    @Override
    public boolean isNull(int position) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            if (this.getRawKeyBlock().isNull(position / 2)) {
                throw new IllegalStateException("Map key is null");
            }
            return false;
        }
        return this.getRawValueBlock().isNull(position / 2);
    }

    @Override
    public byte getByte(int position) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().getByte(position / 2);
        }
        return this.getRawValueBlock().getByte(position / 2);
    }

    @Override
    public short getShort(int position) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().getShort(position / 2);
        }
        return this.getRawValueBlock().getShort(position / 2);
    }

    @Override
    public int getInt(int position) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().getInt(position / 2);
        }
        return this.getRawValueBlock().getInt(position / 2);
    }

    @Override
    public long getLong(int position) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().getLong(position / 2);
        }
        return this.getRawValueBlock().getLong(position / 2);
    }

    @Override
    public long getLong(int position, int offset) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().getLong(position / 2, offset);
        }
        return this.getRawValueBlock().getLong(position / 2, offset);
    }

    @Override
    public Slice getSlice(int position, int offset, int length) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().getSlice(position / 2, offset, length);
        }
        return this.getRawValueBlock().getSlice(position / 2, offset, length);
    }

    @Override
    public int getSliceLength(int position) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().getSliceLength(position / 2);
        }
        return this.getRawValueBlock().getSliceLength(position / 2);
    }

    @Override
    public int compareTo(int position, int offset, int length, Block otherBlock, int otherPosition, int otherOffset, int otherLength) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().compareTo(position / 2, offset, length, otherBlock, otherPosition, otherOffset, otherLength);
        }
        return this.getRawValueBlock().compareTo(position / 2, offset, length, otherBlock, otherPosition, otherOffset, otherLength);
    }

    @Override
    public boolean bytesEqual(int position, int offset, Slice otherSlice, int otherOffset, int length) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().bytesEqual(position / 2, offset, otherSlice, otherOffset, length);
        }
        return this.getRawValueBlock().bytesEqual(position / 2, offset, otherSlice, otherOffset, length);
    }

    @Override
    public int bytesCompare(int position, int offset, int length, Slice otherSlice, int otherOffset, int otherLength) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().bytesCompare(position / 2, offset, length, otherSlice, otherOffset, otherLength);
        }
        return this.getRawValueBlock().bytesCompare(position / 2, offset, length, otherSlice, otherOffset, otherLength);
    }

    @Override
    public void writeBytesTo(int position, int offset, int length, BlockBuilder blockBuilder) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            this.getRawKeyBlock().writeBytesTo(position / 2, offset, length, blockBuilder);
        } else {
            this.getRawValueBlock().writeBytesTo(position / 2, offset, length, blockBuilder);
        }
    }

    @Override
    public boolean equals(int position, int offset, Block otherBlock, int otherPosition, int otherOffset, int length) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().equals(position / 2, offset, otherBlock, otherPosition, otherOffset, length);
        }
        return this.getRawValueBlock().equals(position / 2, offset, otherBlock, otherPosition, otherOffset, length);
    }

    @Override
    public long hash(int position, int offset, int length) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().hash(position / 2, offset, length);
        }
        return this.getRawValueBlock().hash(position / 2, offset, length);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().getObject(position / 2, clazz);
        }
        return this.getRawValueBlock().getObject(position / 2, clazz);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            this.getRawKeyBlock().writePositionTo(position / 2, blockBuilder);
        } else {
            this.getRawValueBlock().writePositionTo(position / 2, blockBuilder);
        }
    }

    @Override
    public Block getSingleValueBlock(int position) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().getSingleValueBlock(position / 2);
        }
        return this.getRawValueBlock().getSingleValueBlock(position / 2);
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        if ((position = this.getAbsolutePosition(position)) % 2 == 0) {
            return this.getRawKeyBlock().getEstimatedDataSizeForStats(position / 2);
        }
        return this.getRawValueBlock().getEstimatedDataSizeForStats(position / 2);
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block copyRegion(int position, int length) {
        throw new UnsupportedOperationException();
    }
}

