/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.function;

import com.facebook.presto.jdbc.internal.spi.function.FunctionKind;
import com.facebook.presto.jdbc.internal.spi.function.OperatorType;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class FunctionMetadata {
    private final String name;
    private final Optional<OperatorType> operatorType;
    private final List<TypeSignature> argumentTypes;
    private final TypeSignature returnType;
    private final FunctionKind functionKind;
    private final boolean deterministic;
    private final boolean calledOnNullInput;

    public FunctionMetadata(String name, List<TypeSignature> argumentTypes, TypeSignature returnType, FunctionKind functionKind, boolean deterministic, boolean calledOnNullInput) {
        this(name, Optional.empty(), argumentTypes, returnType, functionKind, deterministic, calledOnNullInput);
    }

    public FunctionMetadata(OperatorType operatorType, List<TypeSignature> argumentTypes, TypeSignature returnType, FunctionKind functionKind, boolean deterministic, boolean calledOnNullInput) {
        this(operatorType.getFunctionName(), Optional.of(operatorType), argumentTypes, returnType, functionKind, deterministic, calledOnNullInput);
    }

    private FunctionMetadata(String name, Optional<OperatorType> operatorType, List<TypeSignature> argumentTypes, TypeSignature returnType, FunctionKind functionKind, boolean deterministic, boolean calledOnNullInput) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.operatorType = Objects.requireNonNull(operatorType, "operatorType is null");
        this.argumentTypes = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(argumentTypes, "argumentTypes is null")));
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.functionKind = Objects.requireNonNull(functionKind, "functionKind is null");
        this.deterministic = deterministic;
        this.calledOnNullInput = calledOnNullInput;
    }

    public FunctionKind getFunctionKind() {
        return this.functionKind;
    }

    public String getName() {
        return this.name;
    }

    public List<TypeSignature> getArgumentTypes() {
        return this.argumentTypes;
    }

    public TypeSignature getReturnType() {
        return this.returnType;
    }

    public Optional<OperatorType> getOperatorType() {
        return this.operatorType;
    }

    public boolean isDeterministic() {
        return this.deterministic;
    }

    public boolean isCalledOnNullInput() {
        return this.calledOnNullInput;
    }
}

