/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc;

import com.facebook.presto.jdbc.internal.guava.collect.ImmutableList;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignature;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignatureParameter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

class ColumnInfo {
    private static final int VARCHAR_MAX = Integer.MAX_VALUE;
    private static final int VARBINARY_MAX = 0x40000000;
    private static final int TIME_ZONE_MAX = 40;
    private static final int TIME_MAX = "HH:mm:ss.SSS".length();
    private static final int TIME_WITH_TIME_ZONE_MAX = TIME_MAX + 40;
    private static final int TIMESTAMP_MAX = "yyyy-MM-dd HH:mm:ss.SSS".length();
    private static final int TIMESTAMP_WITH_TIME_ZONE_MAX = TIMESTAMP_MAX + 40;
    private static final int DATE_MAX = "yyyy-MM-dd".length();
    private final int columnType;
    private final List<Integer> columnParameterTypes;
    private final TypeSignature columnTypeSignature;
    private final Nullable nullable;
    private final boolean currency;
    private final boolean signed;
    private final int precision;
    private final int scale;
    private final int columnDisplaySize;
    private final String columnLabel;
    private final String columnName;
    private final String tableName;
    private final String schemaName;
    private final String catalogName;

    public ColumnInfo(int columnType, List<Integer> columnParameterTypes, TypeSignature columnTypeSignature, Nullable nullable, boolean currency, boolean signed, int precision, int scale, int columnDisplaySize, String columnLabel, String columnName, String tableName, String schemaName, String catalogName) {
        this.columnType = columnType;
        this.columnParameterTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnParameterTypes, "columnParameterTypes is null"));
        this.columnTypeSignature = Objects.requireNonNull(columnTypeSignature, "columnTypeName is null");
        this.nullable = Objects.requireNonNull(nullable, "nullable is null");
        this.currency = currency;
        this.signed = signed;
        this.precision = precision;
        this.scale = scale;
        this.columnDisplaySize = columnDisplaySize;
        this.columnLabel = Objects.requireNonNull(columnLabel, "columnLabel is null");
        this.columnName = Objects.requireNonNull(columnName, "columnName is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.schemaName = Objects.requireNonNull(schemaName, "schemaName is null");
        this.catalogName = Objects.requireNonNull(catalogName, "catalogName is null");
    }

    public static void setTypeInfo(Builder builder, TypeSignature type) {
        builder.setColumnType(ColumnInfo.getType(type));
        ImmutableList.Builder parameterTypes = ImmutableList.builder();
        for (TypeSignatureParameter parameter : type.getParameters()) {
            parameterTypes.add((Object)ColumnInfo.getType(parameter));
        }
        builder.setColumnParameterTypes((List<Integer>)((Object)parameterTypes.build()));
        switch (type.getBase()) {
            case "boolean": {
                builder.setColumnDisplaySize(5);
                break;
            }
            case "bigint": {
                builder.setSigned(true);
                builder.setPrecision(19);
                builder.setScale(0);
                builder.setColumnDisplaySize(20);
                break;
            }
            case "integer": {
                builder.setSigned(true);
                builder.setPrecision(10);
                builder.setScale(0);
                builder.setColumnDisplaySize(11);
                break;
            }
            case "smallint": {
                builder.setSigned(true);
                builder.setPrecision(5);
                builder.setScale(0);
                builder.setColumnDisplaySize(6);
                break;
            }
            case "tinyint": {
                builder.setSigned(true);
                builder.setPrecision(3);
                builder.setScale(0);
                builder.setColumnDisplaySize(4);
                break;
            }
            case "real": {
                builder.setSigned(true);
                builder.setPrecision(9);
                builder.setScale(0);
                builder.setColumnDisplaySize(16);
                break;
            }
            case "double": {
                builder.setSigned(true);
                builder.setPrecision(17);
                builder.setScale(0);
                builder.setColumnDisplaySize(24);
                break;
            }
            case "char": {
                builder.setSigned(false);
                builder.setPrecision(type.getParameters().get(0).getLongLiteral().intValue());
                builder.setColumnDisplaySize(type.getParameters().get(0).getLongLiteral().intValue());
                builder.setScale(0);
                break;
            }
            case "varchar": {
                builder.setSigned(false);
                builder.setPrecision(Math.min(type.getParameters().get(0).getLongLiteral().intValue(), Integer.MAX_VALUE));
                builder.setColumnDisplaySize(Math.min(type.getParameters().get(0).getLongLiteral().intValue(), Integer.MAX_VALUE));
                builder.setScale(0);
                break;
            }
            case "varbinary": {
                builder.setSigned(true);
                builder.setPrecision(0x40000000);
                builder.setScale(0);
                builder.setColumnDisplaySize(0x40000000);
                break;
            }
            case "time": {
                builder.setSigned(true);
                builder.setPrecision(3);
                builder.setScale(0);
                builder.setColumnDisplaySize(TIME_MAX);
                break;
            }
            case "time with time zone": {
                builder.setSigned(true);
                builder.setPrecision(3);
                builder.setScale(0);
                builder.setColumnDisplaySize(TIME_WITH_TIME_ZONE_MAX);
                break;
            }
            case "timestamp": {
                builder.setSigned(true);
                builder.setPrecision(3);
                builder.setScale(0);
                builder.setColumnDisplaySize(TIMESTAMP_MAX);
                break;
            }
            case "timestamp with time zone": {
                builder.setSigned(true);
                builder.setPrecision(3);
                builder.setScale(0);
                builder.setColumnDisplaySize(TIMESTAMP_WITH_TIME_ZONE_MAX);
                break;
            }
            case "date": {
                builder.setSigned(true);
                builder.setScale(0);
                builder.setColumnDisplaySize(DATE_MAX);
                break;
            }
            case "interval year to month": {
                builder.setColumnDisplaySize(TIMESTAMP_MAX);
                break;
            }
            case "interval day to second": {
                builder.setColumnDisplaySize(TIMESTAMP_MAX);
                break;
            }
            case "decimal": {
                builder.setSigned(true);
                builder.setColumnDisplaySize(type.getParameters().get(0).getLongLiteral().intValue() + 2);
                builder.setPrecision(type.getParameters().get(0).getLongLiteral().intValue());
                builder.setScale(type.getParameters().get(1).getLongLiteral().intValue());
            }
        }
    }

    private static int getType(TypeSignatureParameter typeParameter) {
        switch (typeParameter.getKind()) {
            case TYPE: {
                return ColumnInfo.getType(typeParameter.getTypeSignature());
            }
        }
        return 2000;
    }

    private static int getType(TypeSignature type) {
        switch (type.getBase()) {
            case "array": {
                return 2003;
            }
            case "boolean": {
                return 16;
            }
            case "bigint": {
                return -5;
            }
            case "integer": {
                return 4;
            }
            case "smallint": {
                return 5;
            }
            case "tinyint": {
                return -6;
            }
            case "real": {
                return 7;
            }
            case "double": {
                return 8;
            }
            case "varchar": {
                return 12;
            }
            case "char": {
                return 1;
            }
            case "varbinary": {
                return -3;
            }
            case "time": {
                return 92;
            }
            case "time with time zone": {
                return 92;
            }
            case "timestamp": {
                return 93;
            }
            case "timestamp with time zone": {
                return 93;
            }
            case "date": {
                return 91;
            }
            case "decimal": {
                return 3;
            }
            case "unknown": {
                return 0;
            }
        }
        return 2000;
    }

    public int getColumnType() {
        return this.columnType;
    }

    public List<Integer> getColumnParameterTypes() {
        return this.columnParameterTypes;
    }

    public String getColumnTypeName() {
        return this.columnTypeSignature.toString();
    }

    public TypeSignature getColumnTypeSignature() {
        return this.columnTypeSignature;
    }

    public Nullable getNullable() {
        return this.nullable;
    }

    public boolean isCurrency() {
        return this.currency;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public int getPrecision() {
        return this.precision;
    }

    public int getScale() {
        return this.scale;
    }

    public int getColumnDisplaySize() {
        return this.columnDisplaySize;
    }

    public String getColumnLabel() {
        return this.columnLabel;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    static class Builder {
        private int columnType;
        private List<Integer> columnParameterTypes;
        private TypeSignature columnTypeSignature;
        private Nullable nullable;
        private boolean currency;
        private boolean signed;
        private int precision;
        private int scale;
        private int columnDisplaySize;
        private String columnLabel;
        private String columnName;
        private String tableName;
        private String schemaName;
        private String catalogName;

        Builder() {
        }

        public Builder setColumnType(int columnType) {
            this.columnType = columnType;
            return this;
        }

        public void setColumnParameterTypes(List<Integer> columnParameterTypes) {
            this.columnParameterTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(columnParameterTypes, "columnParameterTypes is null"));
        }

        public Builder setColumnTypeSignature(TypeSignature columnTypeSignature) {
            this.columnTypeSignature = columnTypeSignature;
            return this;
        }

        public Builder setNullable(Nullable nullable) {
            this.nullable = nullable;
            return this;
        }

        public Builder setCurrency(boolean currency) {
            this.currency = currency;
            return this;
        }

        public Builder setSigned(boolean signed) {
            this.signed = signed;
            return this;
        }

        public Builder setPrecision(int precision) {
            this.precision = precision;
            return this;
        }

        public Builder setScale(int scale) {
            this.scale = scale;
            return this;
        }

        public Builder setColumnDisplaySize(int columnDisplaySize) {
            this.columnDisplaySize = columnDisplaySize;
            return this;
        }

        public Builder setColumnLabel(String columnLabel) {
            this.columnLabel = columnLabel;
            return this;
        }

        public Builder setColumnName(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public Builder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder setSchemaName(String schemaName) {
            this.schemaName = schemaName;
            return this;
        }

        public Builder setCatalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public ColumnInfo build() {
            return new ColumnInfo(this.columnType, this.columnParameterTypes, this.columnTypeSignature, this.nullable, this.currency, this.signed, this.precision, this.scale, this.columnDisplaySize, this.columnLabel, this.columnName, this.tableName, this.schemaName, this.catalogName);
        }
    }

    public static enum Nullable {
        NO_NULLS,
        NULLABLE,
        UNKNOWN;

    }
}

