/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.javax.annotation.Nullable;
import com.facebook.presto.jdbc.internal.spi.block.ArrayBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import com.facebook.presto.jdbc.internal.spi.block.IntArrayList;

public abstract class AbstractArrayBlock
implements Block {
    protected abstract Block getRawElementBlock();

    protected abstract int[] getOffsets();

    protected abstract int getOffsetBase();

    @Nullable
    protected abstract boolean[] getValueIsNull();

    int getOffset(int position) {
        return this.getOffsets()[position + this.getOffsetBase()];
    }

    @Override
    public String getEncodingName() {
        return "ARRAY";
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        int[] newOffsets = new int[length + 1];
        boolean[] newValueIsNull = new boolean[length];
        IntArrayList valuesPositions = new IntArrayList();
        int newPosition = 0;
        for (int i = offset; i < offset + length; ++i) {
            int position = positions[i];
            if (this.isNull(position)) {
                newValueIsNull[newPosition] = true;
                newOffsets[newPosition + 1] = newOffsets[newPosition];
            } else {
                int valuesStartOffset = this.getOffset(position);
                int valuesEndOffset = this.getOffset(position + 1);
                int valuesLength = valuesEndOffset - valuesStartOffset;
                newOffsets[newPosition + 1] = newOffsets[newPosition] + valuesLength;
                for (int elementIndex = valuesStartOffset; elementIndex < valuesEndOffset; ++elementIndex) {
                    valuesPositions.add(elementIndex);
                }
            }
            ++newPosition;
        }
        Block newValues = this.getRawElementBlock().copyPositions(valuesPositions.elements(), 0, valuesPositions.size());
        return ArrayBlock.createArrayBlockInternal(0, length, newValueIsNull, newOffsets, newValues);
    }

    @Override
    public Block getRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        return ArrayBlock.createArrayBlockInternal(position + this.getOffsetBase(), length, this.getValueIsNull(), this.getOffsets(), this.getRawElementBlock());
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int valueStart = this.getOffsets()[this.getOffsetBase() + position];
        int valueEnd = this.getOffsets()[this.getOffsetBase() + position + length];
        return this.getRawElementBlock().getRegionSizeInBytes(valueStart, valueEnd - valueStart) + 5L * (long)length;
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions) {
        BlockUtil.checkValidPositions(positions, this.getPositionCount());
        boolean[] used = new boolean[this.getRawElementBlock().getPositionCount()];
        int usedPositionCount = 0;
        for (int i = 0; i < positions.length; ++i) {
            if (!positions[i]) continue;
            ++usedPositionCount;
            int valueStart = this.getOffsets()[this.getOffsetBase() + i];
            int valueEnd = this.getOffsets()[this.getOffsetBase() + i + 1];
            for (int j = valueStart; j < valueEnd; ++j) {
                used[j] = true;
            }
        }
        return this.getRawElementBlock().getPositionsSizeInBytes(used) + 5L * (long)usedPositionCount;
    }

    @Override
    public Block copyRegion(int position, int length) {
        boolean[] newValueIsNull;
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + length);
        Block newValues = this.getRawElementBlock().copyRegion(startValueOffset, endValueOffset - startValueOffset);
        int[] newOffsets = BlockUtil.compactOffsets(this.getOffsets(), position + this.getOffsetBase(), length);
        boolean[] valueIsNull = this.getValueIsNull();
        boolean[] blArray = newValueIsNull = valueIsNull == null ? null : BlockUtil.compactArray(valueIsNull, position + this.getOffsetBase(), length);
        if (newValues == this.getRawElementBlock() && newOffsets == this.getOffsets() && newValueIsNull == valueIsNull) {
            return this;
        }
        return ArrayBlock.createArrayBlockInternal(0, length, newValueIsNull, newOffsets, newValues);
    }

    @Override
    public <T> T getObject(int position, Class<T> clazz) {
        if (clazz != Block.class) {
            throw new IllegalArgumentException("clazz must be Block.class");
        }
        this.checkReadablePosition(position);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        return clazz.cast(this.getRawElementBlock().getRegion(startValueOffset, endValueOffset - startValueOffset));
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        blockBuilder.appendStructureInternal(this, position);
    }

    @Override
    public Block getSingleValueBlock(int position) {
        this.checkReadablePosition(position);
        int startValueOffset = this.getOffset(position);
        int valueLength = this.getOffset(position + 1) - startValueOffset;
        Block newValues = this.getRawElementBlock().copyRegion(startValueOffset, valueLength);
        return ArrayBlock.createArrayBlockInternal(0, 1, new boolean[]{this.isNull(position)}, new int[]{0, valueLength}, newValues);
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        this.checkReadablePosition(position);
        if (this.isNull(position)) {
            return 0L;
        }
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        Block rawElementBlock = this.getRawElementBlock();
        long size = 0L;
        for (int i = startValueOffset; i < endValueOffset; ++i) {
            size += rawElementBlock.getEstimatedDataSizeForStats(i);
        }
        return size;
    }

    @Override
    public boolean mayHaveNull() {
        return this.getValueIsNull() != null;
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        boolean[] valueIsNull = this.getValueIsNull();
        return valueIsNull == null ? false : valueIsNull[position + this.getOffsetBase()];
    }

    public <T> T apply(ArrayBlockFunction<T> function, int position) {
        this.checkReadablePosition(position);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        return function.apply(this.getRawElementBlock(), startValueOffset, endValueOffset - startValueOffset);
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }

    public static interface ArrayBlockFunction<T> {
        public T apply(Block var1, int var2, int var3);
    }
}

