/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.spi.block.AbstractMapBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingSerde;
import com.facebook.presto.jdbc.internal.spi.block.MapBlock;
import com.facebook.presto.jdbc.internal.spi.block.MethodHandleUtil;
import com.facebook.presto.jdbc.internal.spi.block.SingleMapBlock;
import com.facebook.presto.jdbc.internal.spi.function.OperatorType;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import com.facebook.presto.jdbc.internal.spi.type.TypeManager;
import com.facebook.presto.jdbc.internal.spi.type.TypeSerde;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Optional;

public class SingleMapBlockEncoding
implements BlockEncoding {
    public static final String NAME = "MAP_ELEMENT";
    private final TypeManager typeManager;

    public SingleMapBlockEncoding(TypeManager typeManager) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        SingleMapBlock singleMapBlock = (SingleMapBlock)block;
        TypeSerde.writeType(sliceOutput, singleMapBlock.getKeyType());
        int offset = singleMapBlock.getOffset();
        int positionCount = singleMapBlock.getPositionCount();
        blockEncodingSerde.writeBlock(sliceOutput, singleMapBlock.getRawKeyBlock().getRegion(offset / 2, positionCount / 2));
        blockEncodingSerde.writeBlock(sliceOutput, singleMapBlock.getRawValueBlock().getRegion(offset / 2, positionCount / 2));
        int[] hashTable = singleMapBlock.getHashTable();
        if (hashTable != null) {
            int hashTableLength = positionCount / 2 * 2;
            sliceOutput.appendInt(hashTableLength);
            sliceOutput.writeBytes(Slices.wrappedIntArray(hashTable, offset / 2 * 2, hashTableLength));
        } else {
            sliceOutput.appendInt(-1);
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        Type keyType = TypeSerde.readType(this.typeManager, sliceInput);
        MethodHandle keyNativeEquals = this.typeManager.resolveOperator(OperatorType.EQUAL, Arrays.asList(keyType, keyType));
        MethodHandle keyBlockNativeEquals = MethodHandleUtil.compose(keyNativeEquals, MethodHandleUtil.nativeValueGetter(keyType));
        MethodHandle keyNativeHashCode = this.typeManager.resolveOperator(OperatorType.HASH_CODE, Collections.singletonList(keyType));
        MethodHandle keyBlockHashCode = MethodHandleUtil.compose(keyNativeHashCode, MethodHandleUtil.nativeValueGetter(keyType));
        Block keyBlock = blockEncodingSerde.readBlock(sliceInput);
        Block valueBlock = blockEncodingSerde.readBlock(sliceInput);
        int hashTableLength = sliceInput.readInt();
        int[] hashTable = null;
        if (hashTableLength >= 0) {
            hashTable = new int[hashTableLength];
            sliceInput.readBytes(Slices.wrappedIntArray(hashTable));
        }
        if (keyBlock.getPositionCount() != valueBlock.getPositionCount()) {
            throw new IllegalArgumentException(String.format("Deserialized SingleMapBlock violates invariants: key %d, value %d", keyBlock.getPositionCount(), valueBlock.getPositionCount()));
        }
        if (hashTable != null && keyBlock.getPositionCount() * 2 != hashTable.length) {
            throw new IllegalArgumentException(String.format("Deserialized SingleMapBlock violates invariants: expected hashtable size %d, actual hashtable size %d", keyBlock.getPositionCount() * 2, hashTable.length));
        }
        MapBlock mapBlock = MapBlock.createMapBlockInternal(0, 1, Optional.empty(), new int[]{0, keyBlock.getPositionCount()}, keyBlock, valueBlock, new AbstractMapBlock.HashTables(Optional.ofNullable(hashTable), hashTableLength), keyType, keyBlockNativeEquals, keyNativeHashCode, keyBlockHashCode);
        return new SingleMapBlock(0, keyBlock.getPositionCount() * 2, mapBlock);
    }
}

