/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncoding;
import com.facebook.presto.jdbc.internal.spi.block.BlockEncodingSerde;
import com.facebook.presto.jdbc.internal.spi.block.ByteArrayBlock;
import com.facebook.presto.jdbc.internal.spi.block.EncoderUtil;

public class ByteArrayBlockEncoding
implements BlockEncoding {
    public static final String NAME = "BYTE_ARRAY";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public void writeBlock(BlockEncodingSerde blockEncodingSerde, SliceOutput sliceOutput, Block block) {
        int positionCount = block.getPositionCount();
        sliceOutput.appendInt(positionCount);
        EncoderUtil.encodeNullsAsBits(sliceOutput, block);
        for (int position = 0; position < positionCount; ++position) {
            if (block.isNull(position)) continue;
            sliceOutput.writeByte(block.getByte(position));
        }
    }

    @Override
    public Block readBlock(BlockEncodingSerde blockEncodingSerde, SliceInput sliceInput) {
        int positionCount = sliceInput.readInt();
        boolean[] valueIsNull = EncoderUtil.decodeNullBits(sliceInput, positionCount).orElse(null);
        byte[] values = new byte[positionCount];
        for (int position = 0; position < positionCount; ++position) {
            if (valueIsNull != null && valueIsNull[position]) continue;
            values[position] = sliceInput.readByte();
        }
        return new ByteArrayBlock(0, positionCount, valueIsNull, values);
    }
}

