/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.relation;

import com.facebook.presto.jdbc.internal.spi.function.StandardFunctionResolution;
import com.facebook.presto.jdbc.internal.spi.relation.CallExpression;
import com.facebook.presto.jdbc.internal.spi.relation.ConstantExpression;
import com.facebook.presto.jdbc.internal.spi.relation.DeterminismEvaluator;
import com.facebook.presto.jdbc.internal.spi.relation.InputReferenceExpression;
import com.facebook.presto.jdbc.internal.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.jdbc.internal.spi.relation.RowExpression;
import com.facebook.presto.jdbc.internal.spi.relation.RowExpressionVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.SpecialFormExpression;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import com.facebook.presto.jdbc.internal.spi.type.BooleanType;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public final class LogicalRowExpressions {
    public static final ConstantExpression TRUE_CONSTANT = new ConstantExpression(true, BooleanType.BOOLEAN);
    public static final ConstantExpression FALSE_CONSTANT = new ConstantExpression(false, BooleanType.BOOLEAN);
    private final DeterminismEvaluator determinismEvaluator;
    private final StandardFunctionResolution functionResolution;

    public LogicalRowExpressions(DeterminismEvaluator determinismEvaluator, StandardFunctionResolution functionResolution) {
        this.determinismEvaluator = Objects.requireNonNull(determinismEvaluator, "determinismEvaluator is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
    }

    public static List<RowExpression> extractConjuncts(RowExpression expression) {
        return LogicalRowExpressions.extractPredicates(SpecialFormExpression.Form.AND, expression);
    }

    public static List<RowExpression> extractDisjuncts(RowExpression expression) {
        return LogicalRowExpressions.extractPredicates(SpecialFormExpression.Form.OR, expression);
    }

    public static List<RowExpression> extractPredicates(RowExpression expression) {
        SpecialFormExpression.Form form;
        if (expression instanceof SpecialFormExpression && ((form = ((SpecialFormExpression)expression).getForm()) == SpecialFormExpression.Form.AND || form == SpecialFormExpression.Form.OR)) {
            return LogicalRowExpressions.extractPredicates(form, expression);
        }
        return Collections.singletonList(expression);
    }

    public static List<RowExpression> extractPredicates(SpecialFormExpression.Form form, RowExpression expression) {
        if (expression instanceof SpecialFormExpression && ((SpecialFormExpression)expression).getForm() == form) {
            SpecialFormExpression specialFormExpression = (SpecialFormExpression)expression;
            if (specialFormExpression.getArguments().size() != 2) {
                throw new IllegalStateException("logical binary expression requires exactly 2 operands");
            }
            ArrayList<RowExpression> predicates = new ArrayList<RowExpression>();
            predicates.addAll(LogicalRowExpressions.extractPredicates(form, specialFormExpression.getArguments().get(0)));
            predicates.addAll(LogicalRowExpressions.extractPredicates(form, specialFormExpression.getArguments().get(1)));
            return Collections.unmodifiableList(predicates);
        }
        return Collections.singletonList(expression);
    }

    public static RowExpression and(RowExpression ... expressions) {
        return LogicalRowExpressions.and(Arrays.asList(expressions));
    }

    public static RowExpression and(Collection<RowExpression> expressions) {
        return LogicalRowExpressions.binaryExpression(SpecialFormExpression.Form.AND, expressions);
    }

    public static RowExpression or(RowExpression ... expressions) {
        return LogicalRowExpressions.or(Arrays.asList(expressions));
    }

    public static RowExpression or(Collection<RowExpression> expressions) {
        return LogicalRowExpressions.binaryExpression(SpecialFormExpression.Form.OR, expressions);
    }

    public static RowExpression binaryExpression(SpecialFormExpression.Form form, Collection<RowExpression> expressions) {
        Objects.requireNonNull(form, "operator is null");
        Objects.requireNonNull(expressions, "expressions is null");
        if (expressions.isEmpty()) {
            switch (form) {
                case AND: {
                    return TRUE_CONSTANT;
                }
                case OR: {
                    return FALSE_CONSTANT;
                }
            }
            throw new IllegalArgumentException("Unsupported binary expression operator");
        }
        ArrayDeque<RowExpression> queue = new ArrayDeque<RowExpression>(expressions);
        while (queue.size() > 1) {
            ArrayDeque<SpecialFormExpression> buffer = new ArrayDeque<SpecialFormExpression>();
            while (queue.size() >= 2) {
                List<RowExpression> arguments = Arrays.asList((RowExpression)queue.remove(), (RowExpression)queue.remove());
                buffer.add(new SpecialFormExpression(form, (Type)BooleanType.BOOLEAN, arguments));
            }
            if (!queue.isEmpty()) {
                buffer.add((SpecialFormExpression)queue.remove());
            }
            queue = buffer;
        }
        return (RowExpression)queue.remove();
    }

    public RowExpression combinePredicates(SpecialFormExpression.Form form, RowExpression ... expressions) {
        return this.combinePredicates(form, Arrays.asList(expressions));
    }

    public RowExpression combinePredicates(SpecialFormExpression.Form form, Collection<RowExpression> expressions) {
        if (form == SpecialFormExpression.Form.AND) {
            return this.combineConjuncts(expressions);
        }
        return this.combineDisjuncts(expressions);
    }

    public RowExpression combineConjuncts(RowExpression ... expressions) {
        return this.combineConjuncts(Arrays.asList(expressions));
    }

    public RowExpression combineConjuncts(Collection<RowExpression> expressions) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<RowExpression> conjuncts = expressions.stream().flatMap(e -> LogicalRowExpressions.extractConjuncts(e).stream()).filter(e -> !e.equals(TRUE_CONSTANT)).collect(Collectors.toList());
        conjuncts = this.removeDuplicates(conjuncts);
        if (conjuncts.contains(FALSE_CONSTANT)) {
            return FALSE_CONSTANT;
        }
        return LogicalRowExpressions.and(conjuncts);
    }

    public RowExpression combineDisjuncts(RowExpression ... expressions) {
        return this.combineDisjuncts(Arrays.asList(expressions));
    }

    public RowExpression combineDisjuncts(Collection<RowExpression> expressions) {
        return this.combineDisjunctsWithDefault(expressions, FALSE_CONSTANT);
    }

    public RowExpression combineDisjunctsWithDefault(Collection<RowExpression> expressions, RowExpression emptyDefault) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<RowExpression> disjuncts = expressions.stream().flatMap(e -> LogicalRowExpressions.extractDisjuncts(e).stream()).filter(e -> !e.equals(FALSE_CONSTANT)).collect(Collectors.toList());
        disjuncts = this.removeDuplicates(disjuncts);
        if (disjuncts.contains(TRUE_CONSTANT)) {
            return TRUE_CONSTANT;
        }
        return disjuncts.isEmpty() ? emptyDefault : LogicalRowExpressions.or(disjuncts);
    }

    public RowExpression pushNegationToLeaves(RowExpression expression) {
        return expression.accept(new PushNegationVisitor(), null);
    }

    public RowExpression convertToConjunctiveNormalForm(RowExpression expression) {
        return this.convertToNormalForm(expression, SpecialFormExpression.Form.AND);
    }

    public RowExpression convertToDisjunctiveNormalForm(RowExpression expression) {
        return this.convertToNormalForm(expression, SpecialFormExpression.Form.OR);
    }

    public RowExpression convertToNormalForm(RowExpression expression, SpecialFormExpression.Form clauseJoiner) {
        return this.pushNegationToLeaves(expression).accept(new ConvertNormalFormVisitor(), clauseJoiner);
    }

    public RowExpression filterDeterministicConjuncts(RowExpression expression) {
        return this.filterConjuncts(expression, this.determinismEvaluator::isDeterministic);
    }

    public RowExpression filterNonDeterministicConjuncts(RowExpression expression) {
        return this.filterConjuncts(expression, predicate -> !this.determinismEvaluator.isDeterministic((RowExpression)predicate));
    }

    public RowExpression filterConjuncts(RowExpression expression, Predicate<RowExpression> predicate) {
        List<RowExpression> conjuncts = LogicalRowExpressions.extractConjuncts(expression).stream().filter(predicate).collect(Collectors.toList());
        return this.combineConjuncts(conjuncts);
    }

    private List<RowExpression> removeDuplicates(List<RowExpression> expressions) {
        HashSet<RowExpression> seen = new HashSet<RowExpression>();
        ArrayList<RowExpression> result = new ArrayList<RowExpression>();
        for (RowExpression expression : expressions) {
            if (!this.determinismEvaluator.isDeterministic(expression)) {
                result.add(expression);
                continue;
            }
            if (seen.contains(expression)) continue;
            result.add(expression);
            seen.add(expression);
        }
        return Collections.unmodifiableList(result);
    }

    private boolean isConjunctionOrDisjunction(RowExpression expression) {
        if (expression instanceof SpecialFormExpression) {
            SpecialFormExpression.Form form = ((SpecialFormExpression)expression).getForm();
            return form == SpecialFormExpression.Form.AND || form == SpecialFormExpression.Form.OR;
        }
        return false;
    }

    private class ConvertNormalFormVisitor
    implements RowExpressionVisitor<RowExpression, SpecialFormExpression.Form> {
        private ConvertNormalFormVisitor() {
        }

        @Override
        public RowExpression visitSpecialForm(SpecialFormExpression specialForm, SpecialFormExpression.Form clauseJoiner) {
            if (!LogicalRowExpressions.this.isConjunctionOrDisjunction(specialForm)) {
                return specialForm;
            }
            RowExpression left = specialForm.getArguments().get(0).accept(new ConvertNormalFormVisitor(), clauseJoiner);
            RowExpression right = specialForm.getArguments().get(1).accept(new ConvertNormalFormVisitor(), clauseJoiner);
            if (specialForm.getForm() == clauseJoiner) {
                return clauseJoiner == SpecialFormExpression.Form.AND ? LogicalRowExpressions.and(left, right) : LogicalRowExpressions.or(left, right);
            }
            SpecialFormExpression.Form termJoiner = clauseJoiner == SpecialFormExpression.Form.AND ? SpecialFormExpression.Form.OR : SpecialFormExpression.Form.AND;
            List<RowExpression> leftClauses = LogicalRowExpressions.extractPredicates(clauseJoiner, left);
            List<RowExpression> rightClauses = LogicalRowExpressions.extractPredicates(clauseJoiner, right);
            ArrayList<RowExpression> permutationClauses = new ArrayList<RowExpression>();
            for (RowExpression leftClause : leftClauses) {
                for (RowExpression rightClause : rightClauses) {
                    permutationClauses.add(termJoiner == SpecialFormExpression.Form.AND ? LogicalRowExpressions.and(leftClause, rightClause) : LogicalRowExpressions.or(leftClause, rightClause));
                }
            }
            return LogicalRowExpressions.this.combinePredicates(clauseJoiner, Collections.unmodifiableList(permutationClauses));
        }

        @Override
        public RowExpression visitCall(CallExpression call, SpecialFormExpression.Form clauseJoiner) {
            return call;
        }

        @Override
        public RowExpression visitInputReference(InputReferenceExpression reference, SpecialFormExpression.Form clauseJoiner) {
            return reference;
        }

        @Override
        public RowExpression visitConstant(ConstantExpression literal, SpecialFormExpression.Form clauseJoiner) {
            return literal;
        }

        @Override
        public RowExpression visitLambda(LambdaDefinitionExpression lambda, SpecialFormExpression.Form clauseJoiner) {
            return lambda;
        }

        @Override
        public RowExpression visitVariableReference(VariableReferenceExpression reference, SpecialFormExpression.Form clauseJoiner) {
            return reference;
        }
    }

    private final class PushNegationVisitor
    implements RowExpressionVisitor<RowExpression, Void> {
        private PushNegationVisitor() {
        }

        @Override
        public RowExpression visitCall(CallExpression call, Void context) {
            if (!this.isNegationExpression(call)) {
                return call;
            }
            RowExpression argument = call.getArguments().get(0);
            if (this.isNegationExpression(argument)) {
                return ((CallExpression)argument).getArguments().get(0).accept(new PushNegationVisitor(), null);
            }
            if (!LogicalRowExpressions.this.isConjunctionOrDisjunction(argument)) {
                return call;
            }
            SpecialFormExpression specialForm = (SpecialFormExpression)argument;
            RowExpression left = specialForm.getArguments().get(0);
            RowExpression right = specialForm.getArguments().get(1);
            if (specialForm.getForm() == SpecialFormExpression.Form.AND) {
                return LogicalRowExpressions.or(this.notCallExpression(left).accept(new PushNegationVisitor(), null), this.notCallExpression(right).accept(new PushNegationVisitor(), null));
            }
            return LogicalRowExpressions.and(this.notCallExpression(left).accept(new PushNegationVisitor(), null), this.notCallExpression(right).accept(new PushNegationVisitor(), null));
        }

        @Override
        public RowExpression visitSpecialForm(SpecialFormExpression specialForm, Void context) {
            if (!LogicalRowExpressions.this.isConjunctionOrDisjunction(specialForm)) {
                return specialForm;
            }
            RowExpression left = specialForm.getArguments().get(0);
            RowExpression right = specialForm.getArguments().get(1);
            if (specialForm.getForm() == SpecialFormExpression.Form.AND) {
                return LogicalRowExpressions.and(left.accept(new PushNegationVisitor(), null), right.accept(new PushNegationVisitor(), null));
            }
            return LogicalRowExpressions.or(left.accept(new PushNegationVisitor(), null), right.accept(new PushNegationVisitor(), null));
        }

        @Override
        public RowExpression visitInputReference(InputReferenceExpression reference, Void context) {
            return reference;
        }

        @Override
        public RowExpression visitConstant(ConstantExpression literal, Void context) {
            return literal;
        }

        @Override
        public RowExpression visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return lambda;
        }

        @Override
        public RowExpression visitVariableReference(VariableReferenceExpression reference, Void context) {
            return reference;
        }

        private boolean isNegationExpression(RowExpression expression) {
            return expression instanceof CallExpression && ((CallExpression)expression).getFunctionHandle().equals(LogicalRowExpressions.this.functionResolution.notFunction());
        }

        private RowExpression notCallExpression(RowExpression argument) {
            return new CallExpression("not", LogicalRowExpressions.this.functionResolution.notFunction(), BooleanType.BOOLEAN, Collections.singletonList(argument));
        }
    }
}

