/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.airlift.slice.Slices;
import com.facebook.presto.jdbc.internal.airlift.slice.UnsafeSlice;
import com.facebook.presto.jdbc.internal.javax.annotation.Nullable;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.block.AbstractVariableWidthBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import java.util.Optional;
import java.util.function.BiConsumer;

public class VariableWidthBlock
extends AbstractVariableWidthBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(VariableWidthBlock.class).instanceSize();
    private final int arrayOffset;
    private final int positionCount;
    private final Slice slice;
    private final int[] offsets;
    @Nullable
    private final boolean[] valueIsNull;
    private final long retainedSizeInBytes;
    private final long sizeInBytes;

    public VariableWidthBlock(int positionCount, Slice slice, int[] offsets, Optional<boolean[]> valueIsNull) {
        this(0, positionCount, slice, offsets, valueIsNull.orElse(null));
    }

    VariableWidthBlock(int arrayOffset, int positionCount, Slice slice, int[] offsets, boolean[] valueIsNull) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (slice == null) {
            throw new IllegalArgumentException("slice is null");
        }
        this.slice = slice;
        if (offsets.length - arrayOffset < positionCount + 1) {
            throw new IllegalArgumentException("offsets length is less than positionCount");
        }
        this.offsets = offsets;
        if (valueIsNull != null && valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("valueIsNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.sizeInBytes = (long)(offsets[arrayOffset + positionCount] - offsets[arrayOffset]) + 5L * (long)positionCount;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + slice.getRetainedSize() + SizeOf.sizeOf(valueIsNull) + SizeOf.sizeOf(offsets);
    }

    @Override
    protected final int getPositionOffset(int position) {
        return this.offsets[position + this.arrayOffset];
    }

    @Override
    public int getSliceLength(int position) {
        this.checkReadablePosition(position);
        return this.getSliceLengthUnchecked(position + this.arrayOffset);
    }

    @Override
    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    @Override
    protected boolean isEntryNull(int position) {
        return this.valueIsNull != null && this.valueIsNull[position + this.arrayOffset];
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        return this.sizeInBytes;
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        return (long)(this.offsets[this.arrayOffset + position + length] - this.offsets[this.arrayOffset + position]) + 5L * (long)length;
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions) {
        long sizeInBytes = 0L;
        int usedPositionCount = 0;
        for (int i = 0; i < positions.length; ++i) {
            if (!positions[i]) continue;
            ++usedPositionCount;
            sizeInBytes += (long)(this.offsets[this.arrayOffset + i + 1] - this.offsets[this.arrayOffset + i]);
        }
        return sizeInBytes + 5L * (long)usedPositionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.slice, this.slice.getRetainedSize());
        consumer.accept(this.offsets, SizeOf.sizeOf(this.offsets));
        if (this.valueIsNull != null) {
            consumer.accept(this.valueIsNull, SizeOf.sizeOf(this.valueIsNull));
        }
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        int finalLength = 0;
        for (int i = offset; i < offset + length; ++i) {
            finalLength += this.getSliceLength(positions[i]);
        }
        SliceOutput newSlice = Slices.allocate(finalLength).getOutput();
        int[] newOffsets = new int[length + 1];
        boolean[] newValueIsNull = null;
        if (this.valueIsNull != null) {
            newValueIsNull = new boolean[length];
        }
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            if (!this.isEntryNull(position)) {
                newSlice.writeBytes(this.slice, this.getPositionOffset(position), this.getSliceLength(position));
            } else if (newValueIsNull != null) {
                newValueIsNull[i] = true;
            }
            newOffsets[i + 1] = newSlice.size();
        }
        return new VariableWidthBlock(0, length, newSlice.slice(), newOffsets, newValueIsNull);
    }

    @Override
    protected Slice getRawSlice(int position) {
        return this.slice;
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new VariableWidthBlock(positionOffset + this.arrayOffset, length, this.slice, this.offsets, this.valueIsNull);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        boolean[] newValueIsNull;
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        int[] newOffsets = BlockUtil.compactOffsets(this.offsets, positionOffset += this.arrayOffset, length);
        Slice newSlice = BlockUtil.compactSlice(this.slice, this.offsets[positionOffset], newOffsets[length]);
        boolean[] blArray = newValueIsNull = this.valueIsNull == null ? null : BlockUtil.compactArray(this.valueIsNull, positionOffset, length);
        if (newOffsets == this.offsets && newSlice == this.slice && newValueIsNull == this.valueIsNull) {
            return this;
        }
        return new VariableWidthBlock(0, length, newSlice, newOffsets, newValueIsNull);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VariableWidthBlock{");
        sb.append("positionCount=").append(this.getPositionCount());
        sb.append(", slice=").append(this.slice);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public byte getByteUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return UnsafeSlice.getByteUnchecked(this.getRawSlice(internalPosition), this.offsets[internalPosition]);
    }

    @Override
    public short getShortUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return UnsafeSlice.getShortUnchecked(this.getRawSlice(internalPosition), this.offsets[internalPosition]);
    }

    @Override
    public int getIntUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return UnsafeSlice.getIntUnchecked(this.getRawSlice(internalPosition), this.offsets[internalPosition]);
    }

    @Override
    public long getLongUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return UnsafeSlice.getLongUnchecked(this.getRawSlice(internalPosition), this.offsets[internalPosition]);
    }

    @Override
    public long getLongUnchecked(int internalPosition, int offset) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return UnsafeSlice.getLongUnchecked(this.getRawSlice(internalPosition), this.offsets[internalPosition] + offset);
    }

    @Override
    public Slice getSliceUnchecked(int internalPosition, int offset, int length) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.getRawSlice(internalPosition).slice(this.offsets[internalPosition] + offset, length);
    }

    @Override
    public int getSliceLengthUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.offsets[internalPosition + 1] - this.offsets[internalPosition];
    }

    @Override
    public int getOffsetBase() {
        return this.arrayOffset;
    }

    @Override
    public boolean isNullUnchecked(int internalPosition) {
        assert (this.mayHaveNull()) : "no nulls present";
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.valueIsNull[internalPosition];
    }
}

