/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.relation;

import com.facebook.presto.jdbc.internal.spi.function.FunctionMetadataManager;
import com.facebook.presto.jdbc.internal.spi.function.OperatorType;
import com.facebook.presto.jdbc.internal.spi.function.StandardFunctionResolution;
import com.facebook.presto.jdbc.internal.spi.relation.CallExpression;
import com.facebook.presto.jdbc.internal.spi.relation.ConstantExpression;
import com.facebook.presto.jdbc.internal.spi.relation.DeterminismEvaluator;
import com.facebook.presto.jdbc.internal.spi.relation.InputReferenceExpression;
import com.facebook.presto.jdbc.internal.spi.relation.LambdaDefinitionExpression;
import com.facebook.presto.jdbc.internal.spi.relation.RowExpression;
import com.facebook.presto.jdbc.internal.spi.relation.RowExpressionVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.SpecialFormExpression;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import com.facebook.presto.jdbc.internal.spi.type.BooleanType;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public final class LogicalRowExpressions {
    public static final ConstantExpression TRUE_CONSTANT = new ConstantExpression(true, BooleanType.BOOLEAN);
    public static final ConstantExpression FALSE_CONSTANT = new ConstantExpression(false, BooleanType.BOOLEAN);
    private static final int ELIMINATE_COMMON_SIZE_LIMIT = 10000;
    private final DeterminismEvaluator determinismEvaluator;
    private final StandardFunctionResolution functionResolution;
    private final FunctionMetadataManager functionMetadataManager;

    public LogicalRowExpressions(DeterminismEvaluator determinismEvaluator, StandardFunctionResolution functionResolution, FunctionMetadataManager functionMetadataManager) {
        this.determinismEvaluator = Objects.requireNonNull(determinismEvaluator, "determinismEvaluator is null");
        this.functionResolution = Objects.requireNonNull(functionResolution, "functionResolution is null");
        this.functionMetadataManager = Objects.requireNonNull(functionMetadataManager, "functionMetadataManager is null");
    }

    public static List<RowExpression> extractConjuncts(RowExpression expression) {
        return LogicalRowExpressions.extractPredicates(SpecialFormExpression.Form.AND, expression);
    }

    public static List<RowExpression> extractDisjuncts(RowExpression expression) {
        return LogicalRowExpressions.extractPredicates(SpecialFormExpression.Form.OR, expression);
    }

    public static List<RowExpression> extractPredicates(RowExpression expression) {
        SpecialFormExpression.Form form;
        if (expression instanceof SpecialFormExpression && ((form = ((SpecialFormExpression)expression).getForm()) == SpecialFormExpression.Form.AND || form == SpecialFormExpression.Form.OR)) {
            return LogicalRowExpressions.extractPredicates(form, expression);
        }
        return Collections.singletonList(expression);
    }

    public static List<RowExpression> extractPredicates(SpecialFormExpression.Form form, RowExpression expression) {
        if (expression instanceof SpecialFormExpression && ((SpecialFormExpression)expression).getForm() == form) {
            SpecialFormExpression specialFormExpression = (SpecialFormExpression)expression;
            if (specialFormExpression.getArguments().size() != 2) {
                throw new IllegalStateException("logical binary expression requires exactly 2 operands");
            }
            ArrayList<RowExpression> predicates = new ArrayList<RowExpression>();
            predicates.addAll(LogicalRowExpressions.extractPredicates(form, specialFormExpression.getArguments().get(0)));
            predicates.addAll(LogicalRowExpressions.extractPredicates(form, specialFormExpression.getArguments().get(1)));
            return Collections.unmodifiableList(predicates);
        }
        return Collections.singletonList(expression);
    }

    public static RowExpression and(RowExpression ... expressions) {
        return LogicalRowExpressions.and(Arrays.asList(expressions));
    }

    public static RowExpression and(Collection<RowExpression> expressions) {
        return LogicalRowExpressions.binaryExpression(SpecialFormExpression.Form.AND, expressions);
    }

    public static RowExpression or(RowExpression ... expressions) {
        return LogicalRowExpressions.or(Arrays.asList(expressions));
    }

    public static RowExpression or(Collection<RowExpression> expressions) {
        return LogicalRowExpressions.binaryExpression(SpecialFormExpression.Form.OR, expressions);
    }

    public static RowExpression binaryExpression(SpecialFormExpression.Form form, Collection<RowExpression> expressions) {
        Objects.requireNonNull(form, "operator is null");
        Objects.requireNonNull(expressions, "expressions is null");
        if (expressions.isEmpty()) {
            switch (form) {
                case AND: {
                    return TRUE_CONSTANT;
                }
                case OR: {
                    return FALSE_CONSTANT;
                }
            }
            throw new IllegalArgumentException("Unsupported binary expression operator");
        }
        ArrayDeque<RowExpression> queue = new ArrayDeque<RowExpression>(expressions);
        while (queue.size() > 1) {
            ArrayDeque<SpecialFormExpression> buffer = new ArrayDeque<SpecialFormExpression>();
            while (queue.size() >= 2) {
                List<RowExpression> arguments = Arrays.asList((RowExpression)queue.remove(), (RowExpression)queue.remove());
                buffer.add(new SpecialFormExpression(form, (Type)BooleanType.BOOLEAN, arguments));
            }
            if (!queue.isEmpty()) {
                buffer.add((SpecialFormExpression)queue.remove());
            }
            queue = buffer;
        }
        return (RowExpression)queue.remove();
    }

    public RowExpression combinePredicates(SpecialFormExpression.Form form, RowExpression ... expressions) {
        return this.combinePredicates(form, Arrays.asList(expressions));
    }

    public RowExpression combinePredicates(SpecialFormExpression.Form form, Collection<RowExpression> expressions) {
        if (form == SpecialFormExpression.Form.AND) {
            return this.combineConjuncts(expressions);
        }
        return this.combineDisjuncts(expressions);
    }

    public RowExpression combineConjuncts(RowExpression ... expressions) {
        return this.combineConjuncts(Arrays.asList(expressions));
    }

    public RowExpression combineConjuncts(Collection<RowExpression> expressions) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<RowExpression> conjuncts = expressions.stream().flatMap(e -> LogicalRowExpressions.extractConjuncts(e).stream()).filter(e -> !e.equals(TRUE_CONSTANT)).collect(Collectors.toList());
        conjuncts = this.removeDuplicates(conjuncts);
        if (conjuncts.contains(FALSE_CONSTANT)) {
            return FALSE_CONSTANT;
        }
        return LogicalRowExpressions.and(conjuncts);
    }

    public RowExpression combineDisjuncts(RowExpression ... expressions) {
        return this.combineDisjuncts(Arrays.asList(expressions));
    }

    public RowExpression combineDisjuncts(Collection<RowExpression> expressions) {
        return this.combineDisjunctsWithDefault(expressions, FALSE_CONSTANT);
    }

    public RowExpression combineDisjunctsWithDefault(Collection<RowExpression> expressions, RowExpression emptyDefault) {
        Objects.requireNonNull(expressions, "expressions is null");
        List<RowExpression> disjuncts = expressions.stream().flatMap(e -> LogicalRowExpressions.extractDisjuncts(e).stream()).filter(e -> !e.equals(FALSE_CONSTANT)).collect(Collectors.toList());
        disjuncts = this.removeDuplicates(disjuncts);
        if (disjuncts.contains(TRUE_CONSTANT)) {
            return TRUE_CONSTANT;
        }
        return disjuncts.isEmpty() ? emptyDefault : LogicalRowExpressions.or(disjuncts);
    }

    public RowExpression pushNegationToLeaves(RowExpression expression) {
        return expression.accept(new PushNegationVisitor(), null);
    }

    public RowExpression convertToConjunctiveNormalForm(RowExpression expression) {
        return this.convertToNormalForm(expression, SpecialFormExpression.Form.AND);
    }

    public RowExpression convertToDisjunctiveNormalForm(RowExpression expression) {
        return this.convertToNormalForm(expression, SpecialFormExpression.Form.OR);
    }

    public RowExpression minimalNormalForm(RowExpression expression) {
        RowExpression conjunctiveNormalForm = this.convertToConjunctiveNormalForm(expression);
        RowExpression disjunctiveNormalForm = this.convertToDisjunctiveNormalForm(expression);
        return this.numOfClauses(conjunctiveNormalForm) > this.numOfClauses(disjunctiveNormalForm) ? disjunctiveNormalForm : conjunctiveNormalForm;
    }

    public RowExpression convertToNormalForm(RowExpression expression, SpecialFormExpression.Form clauseJoiner) {
        return this.pushNegationToLeaves(expression).accept(new ConvertNormalFormVisitor(), LogicalRowExpressions.rootContext(clauseJoiner));
    }

    public RowExpression filterDeterministicConjuncts(RowExpression expression) {
        return this.filterConjuncts(expression, this.determinismEvaluator::isDeterministic);
    }

    public RowExpression filterNonDeterministicConjuncts(RowExpression expression) {
        return this.filterConjuncts(expression, predicate -> !this.determinismEvaluator.isDeterministic((RowExpression)predicate));
    }

    public RowExpression filterConjuncts(RowExpression expression, Predicate<RowExpression> predicate) {
        List<RowExpression> conjuncts = LogicalRowExpressions.extractConjuncts(expression).stream().filter(predicate).collect(Collectors.toList());
        return this.combineConjuncts(conjuncts);
    }

    private List<RowExpression> removeDuplicates(List<RowExpression> expressions) {
        HashSet<RowExpression> seen = new HashSet<RowExpression>();
        ArrayList<RowExpression> result = new ArrayList<RowExpression>();
        for (RowExpression expression : expressions) {
            if (!this.determinismEvaluator.isDeterministic(expression)) {
                result.add(expression);
                continue;
            }
            if (seen.contains(expression)) continue;
            result.add(expression);
            seen.add(expression);
        }
        return Collections.unmodifiableList(result);
    }

    private boolean isConjunctionOrDisjunction(RowExpression expression) {
        if (expression instanceof SpecialFormExpression) {
            SpecialFormExpression.Form form = ((SpecialFormExpression)expression).getForm();
            return form == SpecialFormExpression.Form.AND || form == SpecialFormExpression.Form.OR;
        }
        return false;
    }

    private static ConvertNormalFormVisitorContext rootContext(SpecialFormExpression.Form clauseJoiner) {
        return new ConvertNormalFormVisitorContext(clauseJoiner, 0);
    }

    private boolean isNegationExpression(RowExpression expression) {
        return expression instanceof CallExpression && ((CallExpression)expression).getFunctionHandle().equals(this.functionResolution.notFunction());
    }

    private boolean isComparisonExpression(RowExpression expression) {
        return expression instanceof CallExpression && this.functionResolution.isComparisonFunction(((CallExpression)expression).getFunctionHandle());
    }

    private List<List<RowExpression>> getGroupedClauses(SpecialFormExpression expression) {
        return LogicalRowExpressions.extractPredicates(expression.getForm(), expression).stream().map(LogicalRowExpressions::extractPredicates).collect(Collectors.toList());
    }

    private int numOfClauses(RowExpression expression) {
        if (expression instanceof SpecialFormExpression) {
            return this.getGroupedClauses((SpecialFormExpression)expression).stream().mapToInt(List::size).sum();
        }
        return 1;
    }

    private List<List<RowExpression>> eliminateCommonPredicates(List<List<RowExpression>> groupedClauses) {
        if (groupedClauses.size() < 2) {
            return groupedClauses;
        }
        int[] reduceTo = IntStream.range(0, groupedClauses.size()).toArray();
        for (int i = 0; i < groupedClauses.size(); ++i) {
            if (!groupedClauses.get(i).stream().allMatch(this.determinismEvaluator::isDeterministic)) continue;
            for (int j = 0; j < groupedClauses.size(); ++j) {
                if (LogicalRowExpressions.isSuperSet((Collection)groupedClauses.get(reduceTo[i]), (Collection)groupedClauses.get(j))) {
                    reduceTo[i] = j;
                    continue;
                }
                if (!LogicalRowExpressions.isSameSet((Collection)groupedClauses.get(reduceTo[i]), (Collection)groupedClauses.get(j))) continue;
                reduceTo[i] = Math.min(reduceTo[i], j);
            }
        }
        return Collections.unmodifiableList(Arrays.stream(reduceTo).distinct().boxed().map(groupedClauses::get).collect(Collectors.toList()));
    }

    private List<List<RowExpression>> extractCommonPredicates(SpecialFormExpression.Form rootClauseJoiner, List<List<RowExpression>> groupedPredicates) {
        if (groupedPredicates.isEmpty()) {
            return null;
        }
        LinkedHashSet commonPredicates = new LinkedHashSet(groupedPredicates.get(0));
        for (int i = 1; i < groupedPredicates.size(); ++i) {
            commonPredicates.retainAll((Collection)groupedPredicates.get(i));
        }
        if (commonPredicates.isEmpty()) {
            return null;
        }
        ArrayList<RowExpression> remainingPredicates = new ArrayList<RowExpression>();
        for (List<RowExpression> group : groupedPredicates) {
            List<RowExpression> remaining = group.stream().filter(predicate -> !commonPredicates.contains(predicate)).collect(Collectors.toList());
            remainingPredicates.add(this.combinePredicates(LogicalRowExpressions.flip(rootClauseJoiner), remaining));
        }
        return Stream.concat(commonPredicates.stream().map(predicate -> Collections.singletonList(predicate)), Stream.of(remainingPredicates)).collect(Collectors.toList());
    }

    private RowExpression combineGroupedClauses(SpecialFormExpression.Form clauseJoiner, List<List<RowExpression>> nestedPredicates) {
        return this.combinePredicates(clauseJoiner, nestedPredicates.stream().map(predicate -> this.combinePredicates(LogicalRowExpressions.flip(clauseJoiner), (Collection<RowExpression>)predicate)).collect(Collectors.toList()));
    }

    private static List<List<RowExpression>> crossProduct(List<List<RowExpression>> groupedPredicates) {
        LogicalRowExpressions.checkArgument(groupedPredicates.size() > 0, "Must contains more than one child", new Object[0]);
        List<List<RowExpression>> result = groupedPredicates.get(0).stream().map(Collections::singletonList).collect(Collectors.toList());
        for (int i = 1; i < groupedPredicates.size(); ++i) {
            result = LogicalRowExpressions.crossProduct(result, groupedPredicates.get(i));
        }
        return result;
    }

    private static List<List<RowExpression>> crossProduct(List<List<RowExpression>> previousCrossProduct, List<RowExpression> clauses) {
        ArrayList<List<RowExpression>> result = new ArrayList<List<RowExpression>>();
        for (List<RowExpression> previousClauses : previousCrossProduct) {
            for (RowExpression newClause : clauses) {
                ArrayList<RowExpression> newClauses = new ArrayList<RowExpression>(previousClauses);
                newClauses.add(newClause);
                result.add(newClauses);
            }
        }
        return result;
    }

    private static SpecialFormExpression.Form flip(SpecialFormExpression.Form binaryLogicalOperation) {
        switch (binaryLogicalOperation) {
            case AND: {
                return SpecialFormExpression.Form.OR;
            }
            case OR: {
                return SpecialFormExpression.Form.AND;
            }
        }
        throw new UnsupportedOperationException("Invalid binary logical operation: " + (Object)((Object)binaryLogicalOperation));
    }

    private Optional<OperatorType> getOperator(RowExpression expression) {
        if (expression instanceof CallExpression) {
            return this.functionMetadataManager.getFunctionMetadata(((CallExpression)expression).getFunctionHandle()).getOperatorType();
        }
        return Optional.empty();
    }

    private RowExpression notCallExpression(RowExpression argument) {
        return new CallExpression("not", this.functionResolution.notFunction(), BooleanType.BOOLEAN, Collections.singletonList(argument));
    }

    private static OperatorType negate(OperatorType operator) {
        switch (operator) {
            case EQUAL: {
                return OperatorType.NOT_EQUAL;
            }
            case NOT_EQUAL: {
                return OperatorType.EQUAL;
            }
            case GREATER_THAN: {
                return OperatorType.LESS_THAN_OR_EQUAL;
            }
            case LESS_THAN: {
                return OperatorType.GREATER_THAN_OR_EQUAL;
            }
            case LESS_THAN_OR_EQUAL: {
                return OperatorType.GREATER_THAN;
            }
            case GREATER_THAN_OR_EQUAL: {
                return OperatorType.LESS_THAN;
            }
        }
        return null;
    }

    private static void checkArgument(boolean condition, String message, Object ... arguments) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message, arguments));
        }
    }

    private static <T> boolean isSuperSet(Collection<T> a, Collection<T> b) {
        return a.size() > b.size() && a.containsAll(b);
    }

    private static <T> boolean isSameSet(Collection<T> a, Collection<T> b) {
        return a.size() == b.size() && a.containsAll(b) && b.containsAll(a);
    }

    private class ConvertNormalFormVisitor
    implements RowExpressionVisitor<RowExpression, ConvertNormalFormVisitorContext> {
        private ConvertNormalFormVisitor() {
        }

        @Override
        public RowExpression visitSpecialForm(SpecialFormExpression specialFormExpression, ConvertNormalFormVisitorContext context) {
            if (!LogicalRowExpressions.this.isConjunctionOrDisjunction(specialFormExpression)) {
                return specialFormExpression;
            }
            RowExpression rewritten = LogicalRowExpressions.this.combinePredicates(specialFormExpression.getForm(), LogicalRowExpressions.extractPredicates(specialFormExpression.getForm(), specialFormExpression).stream().map(subPredicate -> subPredicate.accept(this, context.childContext())).collect(Collectors.toList()));
            if (!LogicalRowExpressions.this.isConjunctionOrDisjunction(rewritten)) {
                return rewritten;
            }
            SpecialFormExpression rewrittenSpecialForm = (SpecialFormExpression)rewritten;
            SpecialFormExpression.Form expressionClauseJoiner = rewrittenSpecialForm.getForm();
            List groupedClauses = LogicalRowExpressions.this.getGroupedClauses(rewrittenSpecialForm);
            if (groupedClauses.stream().mapToInt(List::size).sum() > 10000) {
                return rewritten;
            }
            List groupedClausesWithFlippedJoiner = LogicalRowExpressions.this.extractCommonPredicates(expressionClauseJoiner, groupedClauses = LogicalRowExpressions.this.eliminateCommonPredicates(groupedClauses));
            if (groupedClausesWithFlippedJoiner != null) {
                groupedClauses = groupedClausesWithFlippedJoiner;
                expressionClauseJoiner = LogicalRowExpressions.flip(expressionClauseJoiner);
            }
            int numClauses = groupedClauses.stream().mapToInt(List::size).sum();
            int numClausesProducedByDistributiveLaw = groupedClauses.size();
            for (List group : groupedClauses) {
                if (context.depth <= 0 && (numClausesProducedByDistributiveLaw *= group.size()) <= numClauses * 2) continue;
                return LogicalRowExpressions.this.combineGroupedClauses(expressionClauseJoiner, groupedClauses);
            }
            if (numClausesProducedByDistributiveLaw == numClauses) {
                return LogicalRowExpressions.this.combineGroupedClauses(expressionClauseJoiner, groupedClauses);
            }
            boolean deterministic = groupedClauses.stream().flatMap(Collection::stream).allMatch(LogicalRowExpressions.this.determinismEvaluator::isDeterministic);
            if (expressionClauseJoiner == context.expectedClauseJoiner || !deterministic) {
                return LogicalRowExpressions.this.combineGroupedClauses(expressionClauseJoiner, groupedClauses);
            }
            groupedClauses = LogicalRowExpressions.crossProduct(groupedClauses);
            return LogicalRowExpressions.this.combineGroupedClauses(context.expectedClauseJoiner, groupedClauses);
        }

        @Override
        public RowExpression visitCall(CallExpression call, ConvertNormalFormVisitorContext context) {
            return call;
        }

        @Override
        public RowExpression visitInputReference(InputReferenceExpression reference, ConvertNormalFormVisitorContext context) {
            return reference;
        }

        @Override
        public RowExpression visitConstant(ConstantExpression literal, ConvertNormalFormVisitorContext context) {
            return literal;
        }

        @Override
        public RowExpression visitLambda(LambdaDefinitionExpression lambda, ConvertNormalFormVisitorContext context) {
            return lambda;
        }

        @Override
        public RowExpression visitVariableReference(VariableReferenceExpression reference, ConvertNormalFormVisitorContext context) {
            return reference;
        }
    }

    private static class ConvertNormalFormVisitorContext {
        private final SpecialFormExpression.Form expectedClauseJoiner;
        private final int depth;

        public ConvertNormalFormVisitorContext(SpecialFormExpression.Form expectedClauseJoiner, int depth) {
            this.expectedClauseJoiner = expectedClauseJoiner;
            this.depth = depth;
        }

        public ConvertNormalFormVisitorContext childContext() {
            return new ConvertNormalFormVisitorContext(this.expectedClauseJoiner, this.depth + 1);
        }
    }

    private final class PushNegationVisitor
    implements RowExpressionVisitor<RowExpression, Void> {
        private PushNegationVisitor() {
        }

        @Override
        public RowExpression visitCall(CallExpression call, Void context) {
            if (!LogicalRowExpressions.this.isNegationExpression(call)) {
                return call;
            }
            LogicalRowExpressions.checkArgument(call.getArguments().size() == 1, "Not expression should have exactly one argument", new Object[0]);
            RowExpression argument = call.getArguments().get(0);
            if (LogicalRowExpressions.this.isNegationExpression(argument)) {
                return ((CallExpression)argument).getArguments().get(0).accept(new PushNegationVisitor(), null);
            }
            if (LogicalRowExpressions.this.isComparisonExpression(argument)) {
                return this.negateComparison((CallExpression)argument);
            }
            if (!LogicalRowExpressions.this.isConjunctionOrDisjunction(argument)) {
                return call;
            }
            SpecialFormExpression specialForm = (SpecialFormExpression)argument;
            RowExpression left = specialForm.getArguments().get(0);
            RowExpression right = specialForm.getArguments().get(1);
            if (specialForm.getForm() == SpecialFormExpression.Form.AND) {
                return LogicalRowExpressions.or(LogicalRowExpressions.this.notCallExpression(left).accept(new PushNegationVisitor(), null), LogicalRowExpressions.this.notCallExpression(right).accept(this, null));
            }
            return LogicalRowExpressions.and(LogicalRowExpressions.this.notCallExpression(left).accept(new PushNegationVisitor(), null), LogicalRowExpressions.this.notCallExpression(right).accept(this, null));
        }

        private RowExpression negateComparison(CallExpression expression) {
            OperatorType newOperator = LogicalRowExpressions.negate(LogicalRowExpressions.this.getOperator(expression).orElse(null));
            if (newOperator == null) {
                return new CallExpression("NOT", LogicalRowExpressions.this.functionResolution.notFunction(), BooleanType.BOOLEAN, Collections.singletonList(expression));
            }
            LogicalRowExpressions.checkArgument(expression.getArguments().size() == 2, "Comparison expression must have exactly two arguments", new Object[0]);
            RowExpression left = expression.getArguments().get(0).accept(this, null);
            RowExpression right = expression.getArguments().get(1).accept(this, null);
            return new CallExpression(newOperator.getOperator(), LogicalRowExpressions.this.functionResolution.comparisonFunction(newOperator, left.getType(), right.getType()), BooleanType.BOOLEAN, Arrays.asList(left, right));
        }

        @Override
        public RowExpression visitSpecialForm(SpecialFormExpression specialForm, Void context) {
            if (!LogicalRowExpressions.this.isConjunctionOrDisjunction(specialForm)) {
                return specialForm;
            }
            RowExpression left = specialForm.getArguments().get(0);
            RowExpression right = specialForm.getArguments().get(1);
            if (specialForm.getForm() == SpecialFormExpression.Form.AND) {
                return LogicalRowExpressions.and(left.accept(this, null), right.accept(this, null));
            }
            return LogicalRowExpressions.or(left.accept(this, null), right.accept(this, null));
        }

        @Override
        public RowExpression visitInputReference(InputReferenceExpression reference, Void context) {
            return reference;
        }

        @Override
        public RowExpression visitConstant(ConstantExpression literal, Void context) {
            return literal;
        }

        @Override
        public RowExpression visitLambda(LambdaDefinitionExpression lambda, Void context) {
            return lambda;
        }

        @Override
        public RowExpression visitVariableReference(VariableReferenceExpression reference, Void context) {
            return reference;
        }
    }
}

