/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.function;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.function.FunctionKind;
import com.facebook.presto.jdbc.internal.spi.function.LongVariableConstraint;
import com.facebook.presto.jdbc.internal.spi.function.TypeVariableConstraint;
import com.facebook.presto.jdbc.internal.spi.relation.FullyQualifiedName;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class Signature {
    private final FullyQualifiedName name;
    private final FunctionKind kind;
    private final List<TypeVariableConstraint> typeVariableConstraints;
    private final List<LongVariableConstraint> longVariableConstraints;
    private final TypeSignature returnType;
    private final List<TypeSignature> argumentTypes;
    private final boolean variableArity;

    @JsonCreator
    public Signature(@JsonProperty(value="name") FullyQualifiedName name, @JsonProperty(value="kind") FunctionKind kind, @JsonProperty(value="typeVariableConstraints") List<TypeVariableConstraint> typeVariableConstraints, @JsonProperty(value="longVariableConstraints") List<LongVariableConstraint> longVariableConstraints, @JsonProperty(value="returnType") TypeSignature returnType, @JsonProperty(value="argumentTypes") List<TypeSignature> argumentTypes, @JsonProperty(value="variableArity") boolean variableArity) {
        Objects.requireNonNull(name, "name is null");
        Objects.requireNonNull(typeVariableConstraints, "typeVariableConstraints is null");
        Objects.requireNonNull(longVariableConstraints, "longVariableConstraints is null");
        this.name = name;
        this.kind = Objects.requireNonNull(kind, "type is null");
        this.typeVariableConstraints = Collections.unmodifiableList(new ArrayList<TypeVariableConstraint>(typeVariableConstraints));
        this.longVariableConstraints = Collections.unmodifiableList(new ArrayList<LongVariableConstraint>(longVariableConstraints));
        this.returnType = Objects.requireNonNull(returnType, "returnType is null");
        this.argumentTypes = Collections.unmodifiableList(new ArrayList(Objects.requireNonNull(argumentTypes, "argumentTypes is null")));
        this.variableArity = variableArity;
    }

    public Signature(FullyQualifiedName name, FunctionKind kind, TypeSignature returnType, TypeSignature ... argumentTypes) {
        this(name, kind, returnType, Collections.unmodifiableList(Arrays.asList(argumentTypes)));
    }

    public Signature(FullyQualifiedName name, FunctionKind kind, TypeSignature returnType, List<TypeSignature> argumentTypes) {
        this(name, kind, Collections.emptyList(), Collections.emptyList(), returnType, argumentTypes, false);
    }

    @JsonProperty
    public FullyQualifiedName getName() {
        return this.name;
    }

    public String getNameSuffix() {
        return this.name.getSuffix();
    }

    @JsonProperty
    public FunctionKind getKind() {
        return this.kind;
    }

    @JsonProperty
    public TypeSignature getReturnType() {
        return this.returnType;
    }

    @JsonProperty
    public List<TypeSignature> getArgumentTypes() {
        return this.argumentTypes;
    }

    @JsonProperty
    public boolean isVariableArity() {
        return this.variableArity;
    }

    @JsonProperty
    public List<TypeVariableConstraint> getTypeVariableConstraints() {
        return this.typeVariableConstraints;
    }

    @JsonProperty
    public List<LongVariableConstraint> getLongVariableConstraints() {
        return this.longVariableConstraints;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.kind, this.typeVariableConstraints, this.longVariableConstraints, this.returnType, this.argumentTypes, this.variableArity});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Signature other = (Signature)obj;
        return Objects.equals(this.name, other.name) && Objects.equals((Object)this.kind, (Object)other.kind) && Objects.equals(this.typeVariableConstraints, other.typeVariableConstraints) && Objects.equals(this.longVariableConstraints, other.longVariableConstraints) && Objects.equals(this.returnType, other.returnType) && Objects.equals(this.argumentTypes, other.argumentTypes) && Objects.equals(this.variableArity, other.variableArity);
    }

    public String toString() {
        List allConstraints = Stream.concat(this.typeVariableConstraints.stream().map(TypeVariableConstraint::toString), this.longVariableConstraints.stream().map(LongVariableConstraint::toString)).collect(Collectors.toList());
        return this.name + (allConstraints.isEmpty() ? "" : "<" + String.join((CharSequence)",", allConstraints) + ">") + "(" + String.join((CharSequence)",", this.argumentTypes.stream().map(TypeSignature::toString).collect(Collectors.toList())) + "):" + this.returnType;
    }

    public static TypeVariableConstraint withVariadicBound(String name, String variadicBound) {
        return new TypeVariableConstraint(name, false, false, variadicBound);
    }

    public static TypeVariableConstraint comparableWithVariadicBound(String name, String variadicBound) {
        return new TypeVariableConstraint(name, true, false, variadicBound);
    }

    public static TypeVariableConstraint typeVariable(String name) {
        return new TypeVariableConstraint(name, false, false, null);
    }

    public static TypeVariableConstraint comparableTypeParameter(String name) {
        return new TypeVariableConstraint(name, true, false, null);
    }

    public static TypeVariableConstraint orderableWithVariadicBound(String name, String variadicBound) {
        return new TypeVariableConstraint(name, false, true, variadicBound);
    }

    public static TypeVariableConstraint orderableTypeParameter(String name) {
        return new TypeVariableConstraint(name, false, true, null);
    }

    public static LongVariableConstraint longVariableExpression(String variable, String expression) {
        return new LongVariableConstraint(variable, expression);
    }
}

