/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.block;

import com.facebook.presto.jdbc.internal.io.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.javax.annotation.Nullable;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.ErrorCodeSupplier;
import com.facebook.presto.jdbc.internal.spi.PrestoException;
import com.facebook.presto.jdbc.internal.spi.StandardErrorCode;
import com.facebook.presto.jdbc.internal.spi.block.AbstractMapBlock;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.block.BlockUtil;
import com.facebook.presto.jdbc.internal.spi.block.DuplicateMapKeyException;
import com.facebook.presto.jdbc.internal.spi.block.MapBlock;
import com.facebook.presto.jdbc.internal.spi.block.SingleMapBlock;
import com.facebook.presto.jdbc.internal.spi.block.SingleMapBlockWriter;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;

public class MapBlockBuilder
extends AbstractMapBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MapBlockBuilder.class).instanceSize();
    private final MethodHandle keyBlockEquals;
    @Nullable
    private final BlockBuilderStatus blockBuilderStatus;
    private int positionCount;
    private int[] offsets;
    private boolean[] mapIsNull;
    private final BlockBuilder keyBlockBuilder;
    private final BlockBuilder valueBlockBuilder;
    private AbstractMapBlock.HashTables hashTables;
    private boolean currentEntryOpened;

    public MapBlockBuilder(Type keyType, Type valueType, MethodHandle keyBlockNativeEquals, MethodHandle keyBlockEquals, MethodHandle keyNativeHashCode, MethodHandle keyBlockHashCode, BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        this(keyType, keyBlockNativeEquals, keyBlockEquals, keyNativeHashCode, keyBlockHashCode, blockBuilderStatus, keyType.createBlockBuilder(blockBuilderStatus, expectedEntries), valueType.createBlockBuilder(blockBuilderStatus, expectedEntries), new int[expectedEntries + 1], new boolean[expectedEntries], MapBlockBuilder.newNegativeOneFilledArray(expectedEntries * 2));
    }

    private MapBlockBuilder(Type keyType, MethodHandle keyBlockNativeEquals, MethodHandle keyBlockEquals, MethodHandle keyNativeHashCode, MethodHandle keyBlockHashCode, @Nullable BlockBuilderStatus blockBuilderStatus, BlockBuilder keyBlockBuilder, BlockBuilder valueBlockBuilder, int[] offsets, boolean[] mapIsNull, int[] rawHashTables) {
        super(keyType, keyNativeHashCode, keyBlockNativeEquals, keyBlockHashCode);
        this.keyBlockEquals = Objects.requireNonNull(keyBlockEquals, "keyBlockEquals is null");
        this.blockBuilderStatus = blockBuilderStatus;
        this.positionCount = 0;
        this.offsets = Objects.requireNonNull(offsets, "offsets is null");
        this.mapIsNull = Objects.requireNonNull(mapIsNull, "mapIsNull is null");
        this.keyBlockBuilder = Objects.requireNonNull(keyBlockBuilder, "keyBlockBuilder is null");
        this.valueBlockBuilder = Objects.requireNonNull(valueBlockBuilder, "valueBlockBuilder is null");
        this.hashTables = new AbstractMapBlock.HashTables(Optional.of(Objects.requireNonNull(rawHashTables, "hashTables is null")), 0, rawHashTables.length);
    }

    @Override
    protected Block getRawKeyBlock() {
        return this.keyBlockBuilder;
    }

    @Override
    protected Block getRawValueBlock() {
        return this.valueBlockBuilder;
    }

    @Override
    protected AbstractMapBlock.HashTables getHashTables() {
        return this.hashTables;
    }

    @Override
    protected int[] getOffsets() {
        return this.offsets;
    }

    @Override
    public int getOffsetBase() {
        return 0;
    }

    @Override
    protected boolean[] getMapIsNull() {
        return this.mapIsNull;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        return this.keyBlockBuilder.getSizeInBytes() + this.valueBlockBuilder.getSizeInBytes() + 5L * (long)this.positionCount + 8L * (long)this.keyBlockBuilder.getPositionCount() + this.hashTables.getInstanceSizeInBytes();
    }

    @Override
    public long getRetainedSizeInBytes() {
        long size = (long)INSTANCE_SIZE + this.keyBlockBuilder.getRetainedSizeInBytes() + this.valueBlockBuilder.getRetainedSizeInBytes() + SizeOf.sizeOf(this.offsets) + SizeOf.sizeOf(this.mapIsNull) + this.hashTables.getRetainedSizeInBytes();
        if (this.blockBuilderStatus != null) {
            size += (long)BlockBuilderStatus.INSTANCE_SIZE;
        }
        return size;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.keyBlockBuilder, this.keyBlockBuilder.getRetainedSizeInBytes());
        consumer.accept(this.valueBlockBuilder, this.valueBlockBuilder.getRetainedSizeInBytes());
        consumer.accept(this.offsets, SizeOf.sizeOf(this.offsets));
        consumer.accept(this.mapIsNull, SizeOf.sizeOf(this.mapIsNull));
        consumer.accept(this.hashTables, this.hashTables.getRetainedSizeInBytes());
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public SingleMapBlockWriter beginBlockEntry() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Expected current entry to be closed but was opened");
        }
        this.currentEntryOpened = true;
        return new SingleMapBlockWriter(this.keyBlockBuilder.getPositionCount() * 2, this.keyBlockBuilder, this.valueBlockBuilder);
    }

    @Override
    public BlockBuilder closeEntry() {
        if (!this.currentEntryOpened) {
            throw new IllegalStateException("Expected entry to be opened but was closed");
        }
        this.entryAdded(false);
        this.currentEntryOpened = false;
        this.ensureHashTableSize();
        int previousAggregatedEntryCount = this.offsets[this.positionCount - 1];
        int aggregatedEntryCount = this.offsets[this.positionCount];
        int entryCount = aggregatedEntryCount - previousAggregatedEntryCount;
        Optional<int[]> rawHashTables = this.hashTables.get();
        MapBlockBuilder.verify(rawHashTables.isPresent(), "rawHashTables is empty");
        MapBlockBuilder.buildHashTable(this.keyBlockBuilder, previousAggregatedEntryCount, entryCount, this.keyBlockHashCode, rawHashTables.get(), previousAggregatedEntryCount * 2, entryCount * 2);
        return this;
    }

    public BlockBuilder closeEntryStrict() throws DuplicateMapKeyException {
        if (!this.currentEntryOpened) {
            throw new IllegalStateException("Expected entry to be opened but was closed");
        }
        this.entryAdded(false);
        this.currentEntryOpened = false;
        this.ensureHashTableSize();
        int previousAggregatedEntryCount = this.offsets[this.positionCount - 1];
        int aggregatedEntryCount = this.offsets[this.positionCount];
        int entryCount = aggregatedEntryCount - previousAggregatedEntryCount;
        Optional<int[]> rawHashTables = this.hashTables.get();
        MapBlockBuilder.verify(rawHashTables.isPresent(), "rawHashTables is empty");
        MapBlockBuilder.buildHashTableStrict(this.keyBlockBuilder, previousAggregatedEntryCount, entryCount, this.keyBlockEquals, this.keyBlockHashCode, rawHashTables.get(), previousAggregatedEntryCount * 2, entryCount * 2);
        return this;
    }

    private BlockBuilder closeEntry(@Nullable int[] providedHashTable, int providedHashTableOffset) {
        if (!this.currentEntryOpened) {
            throw new IllegalStateException("Expected entry to be opened but was closed");
        }
        this.entryAdded(false);
        this.currentEntryOpened = false;
        this.ensureHashTableSize();
        int previousAggregatedEntryCount = this.offsets[this.positionCount - 1];
        int aggregatedEntryCount = this.offsets[this.positionCount];
        Optional<int[]> rawHashTables = this.hashTables.get();
        MapBlockBuilder.verify(rawHashTables.isPresent(), "rawHashTables is empty");
        if (providedHashTable != null) {
            int hashTableOffset = previousAggregatedEntryCount * 2;
            int hashTableSize = (aggregatedEntryCount - previousAggregatedEntryCount) * 2;
            for (int i = 0; i < hashTableSize; ++i) {
                rawHashTables.get()[hashTableOffset + i] = providedHashTable[providedHashTableOffset + i];
            }
        } else {
            int entryCount = aggregatedEntryCount - previousAggregatedEntryCount;
            MapBlockBuilder.buildHashTable(this.keyBlockBuilder, previousAggregatedEntryCount, entryCount, this.keyBlockHashCode, rawHashTables.get(), previousAggregatedEntryCount * 2, entryCount * 2);
        }
        return this;
    }

    @Override
    public BlockBuilder appendNull() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before a null can be written");
        }
        this.entryAdded(true);
        return this;
    }

    private void entryAdded(boolean isNull) {
        if (this.keyBlockBuilder.getPositionCount() != this.valueBlockBuilder.getPositionCount()) {
            throw new IllegalStateException(String.format("keyBlock and valueBlock has different size: %s %s", this.keyBlockBuilder.getPositionCount(), this.valueBlockBuilder.getPositionCount()));
        }
        if (this.mapIsNull.length <= this.positionCount) {
            int newSize = BlockUtil.calculateNewArraySize(this.mapIsNull.length);
            this.mapIsNull = Arrays.copyOf(this.mapIsNull, newSize);
            this.offsets = Arrays.copyOf(this.offsets, newSize + 1);
        }
        this.offsets[this.positionCount + 1] = this.keyBlockBuilder.getPositionCount();
        this.mapIsNull[this.positionCount] = isNull;
        ++this.positionCount;
        if (this.blockBuilderStatus != null) {
            this.blockBuilderStatus.addBytes(5);
            this.blockBuilderStatus.addBytes((this.offsets[this.positionCount] - this.offsets[this.positionCount - 1]) * 2 * 4);
        }
    }

    private void ensureHashTableSize() {
        Optional<int[]> rawHashTables = this.hashTables.get();
        MapBlockBuilder.verify(rawHashTables.isPresent(), "rawHashTables is empty");
        if (rawHashTables.get().length < this.offsets[this.positionCount] * 2) {
            int newSize = BlockUtil.calculateNewArraySize(this.offsets[this.positionCount] * 2);
            int[] newRawHashTables = Arrays.copyOf(rawHashTables.get(), newSize);
            Arrays.fill(newRawHashTables, rawHashTables.get().length, newSize, -1);
            this.hashTables.set(newRawHashTables);
        }
    }

    @Override
    public Block build() {
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Current entry must be closed before the block can be built");
        }
        Optional<int[]> rawHashTables = this.hashTables.get();
        MapBlockBuilder.verify(rawHashTables.isPresent(), "rawHashTables is empty");
        int hashTablesEntries = this.offsets[this.positionCount] * 2;
        return MapBlock.createMapBlockInternal(0, this.positionCount, Optional.of(this.mapIsNull), this.offsets, this.keyBlockBuilder.build(), this.valueBlockBuilder.build(), new AbstractMapBlock.HashTables(Optional.of(Arrays.copyOf(rawHashTables.get(), hashTablesEntries)), this.positionCount, hashTablesEntries), this.keyType, this.keyBlockNativeEquals, this.keyNativeHashCode, this.keyBlockHashCode);
    }

    public String toString() {
        return "MapBlockBuilder{positionCount=" + this.getPositionCount() + '}';
    }

    @Override
    public BlockBuilder appendStructure(Block block) {
        if (!(block instanceof SingleMapBlock)) {
            throw new IllegalArgumentException("Expected SingleMapBlock");
        }
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Expected current entry to be closed but was opened");
        }
        this.currentEntryOpened = true;
        SingleMapBlock singleMapBlock = (SingleMapBlock)block;
        int blockPositionCount = singleMapBlock.getPositionCount();
        if (blockPositionCount % 2 != 0) {
            throw new IllegalArgumentException(String.format("block position count is not even: %s", blockPositionCount));
        }
        for (int i = 0; i < blockPositionCount; i += 2) {
            if (singleMapBlock.isNull(i)) {
                throw new IllegalArgumentException("Map keys must not be null");
            }
            singleMapBlock.writePositionTo(i, this.keyBlockBuilder);
            if (singleMapBlock.isNull(i + 1)) {
                this.valueBlockBuilder.appendNull();
                continue;
            }
            singleMapBlock.writePositionTo(i + 1, this.valueBlockBuilder);
        }
        this.closeEntry(singleMapBlock.getHashTable(), singleMapBlock.getOffsetBase() / 2 * 2);
        return this;
    }

    @Override
    public BlockBuilder appendStructureInternal(Block block, int position) {
        if (!(block instanceof AbstractMapBlock)) {
            throw new IllegalArgumentException("Expected AbstractMapBlock");
        }
        if (this.currentEntryOpened) {
            throw new IllegalStateException("Expected current entry to be closed but was opened");
        }
        this.currentEntryOpened = true;
        AbstractMapBlock mapBlock = (AbstractMapBlock)block;
        int startValueOffset = mapBlock.getOffset(position);
        int endValueOffset = mapBlock.getOffset(position + 1);
        for (int i = startValueOffset; i < endValueOffset; ++i) {
            if (mapBlock.getRawKeyBlock().isNull(i)) {
                throw new IllegalArgumentException("Map keys must not be null");
            }
            mapBlock.getRawKeyBlock().writePositionTo(i, this.keyBlockBuilder);
            if (mapBlock.getRawValueBlock().isNull(i)) {
                this.valueBlockBuilder.appendNull();
                continue;
            }
            mapBlock.getRawValueBlock().writePositionTo(i, this.valueBlockBuilder);
        }
        this.closeEntry(mapBlock.getHashTables().get().orElse(null), startValueOffset * 2);
        return this;
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        int newSize = BlockUtil.calculateBlockResetSize(this.getPositionCount());
        return new MapBlockBuilder(this.keyType, this.keyBlockNativeEquals, this.keyBlockEquals, this.keyNativeHashCode, this.keyBlockHashCode, blockBuilderStatus, this.keyBlockBuilder.newBlockBuilderLike(blockBuilderStatus), this.valueBlockBuilder.newBlockBuilderLike(blockBuilderStatus), new int[newSize + 1], new boolean[newSize], MapBlockBuilder.newNegativeOneFilledArray(newSize * 2));
    }

    @Override
    protected void ensureHashTableLoaded() {
    }

    private static int[] newNegativeOneFilledArray(int size) {
        int[] hashTable = new int[size];
        Arrays.fill(hashTable, -1);
        return hashTable;
    }

    static void buildHashTable(Block keyBlock, int keyOffset, int keyCount, MethodHandle keyBlockHashCode, int[] outputHashTable, int hashTableOffset, int hashTableSize) {
        int i = 0;
        while (i < keyCount) {
            int hash = MapBlockBuilder.getHashPosition(keyBlock, keyOffset + i, keyBlockHashCode, hashTableSize);
            while (true) {
                if (outputHashTable[hashTableOffset + hash] == -1) break;
                if (++hash != hashTableSize) continue;
                hash = 0;
            }
            outputHashTable[hashTableOffset + hash] = i++;
        }
    }

    private static void buildHashTableStrict(Block keyBlock, int keyOffset, int keyCount, MethodHandle keyBlockEquals, MethodHandle keyBlockHashCode, int[] outputHashTable, int hashTableOffset, int hashTableSize) throws DuplicateMapKeyException {
        int i = 0;
        while (i < keyCount) {
            int hash = MapBlockBuilder.getHashPosition(keyBlock, keyOffset + i, keyBlockHashCode, hashTableSize);
            while (true) {
                Boolean isDuplicateKey;
                if (outputHashTable[hashTableOffset + hash] == -1) break;
                try {
                    isDuplicateKey = keyBlockEquals.invokeExact(keyBlock, keyOffset + i, keyBlock, keyOffset + outputHashTable[hashTableOffset + hash]);
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Throwable throwable) {
                    throw new RuntimeException(throwable);
                }
                if (isDuplicateKey == null) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "map key cannot be null or contain nulls");
                }
                if (isDuplicateKey.booleanValue()) {
                    throw new DuplicateMapKeyException(keyBlock, keyOffset + i);
                }
                if (++hash != hashTableSize) continue;
                hash = 0;
            }
            outputHashTable[hashTableOffset + hash] = i++;
        }
    }

    private static int getHashPosition(Block keyBlock, int position, MethodHandle keyBlockHashCode, int hashTableSize) {
        long hashCode;
        if (keyBlock.isNull(position)) {
            throw new IllegalArgumentException("map keys cannot be null");
        }
        try {
            hashCode = keyBlockHashCode.invokeExact(keyBlock, position);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
        return MapBlockBuilder.computePosition(hashCode, hashTableSize);
    }

    static int computePosition(long hashcode, int hashTableSize) {
        return (int)(Integer.toUnsignedLong(Long.hashCode(hashcode)) * (long)hashTableSize >> 32);
    }

    static void verify(boolean assertion, String message) {
        if (!assertion) {
            throw new AssertionError((Object)message);
        }
    }
}

