/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.function;

import java.util.Objects;

public class RoutineCharacteristics {
    private final Language language;
    private final Determinism determinism;
    private final NullCallClause nullCallClause;

    public RoutineCharacteristics(Language language, Determinism determinism, NullCallClause nullCallClause) {
        this.language = Objects.requireNonNull(language, "language is null");
        this.determinism = Objects.requireNonNull(determinism, "determinism is null");
        this.nullCallClause = Objects.requireNonNull(nullCallClause, "nullCallClause is null");
    }

    public Language getLanguage() {
        return this.language;
    }

    public boolean isDeterministic() {
        return this.determinism == Determinism.DETERMINISTIC;
    }

    public boolean isCalledOnNullInput() {
        return this.nullCallClause == NullCallClause.CALLED_ON_NULL_INPUT;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RoutineCharacteristics that = (RoutineCharacteristics)o;
        return this.language == that.language && this.determinism == that.determinism && this.nullCallClause == that.nullCallClause;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.language, this.determinism, this.nullCallClause});
    }

    public String toString() {
        return String.format("(%s, %s, %s)", new Object[]{this.language, this.determinism, this.nullCallClause});
    }

    public static enum NullCallClause {
        RETURNS_NULL_ON_NULL_INPUT,
        CALLED_ON_NULL_INPUT;

    }

    public static enum Determinism {
        DETERMINISTIC,
        NOT_DETERMINISTIC;

    }

    public static enum Language {
        SQL;

    }
}

