/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.function;

import com.facebook.presto.jdbc.internal.spi.type.TimeZoneKey;
import java.util.Objects;

public class SqlFunctionProperties {
    private final boolean parseDecimalLiteralAsDouble;
    private final boolean legacyRowFieldOrdinalAccessEnabled;
    private final TimeZoneKey timeZoneKey;
    private final boolean legacyTimestamp;

    private SqlFunctionProperties(boolean parseDecimalLiteralAsDouble, boolean legacyRowFieldOrdinalAccessEnabled, TimeZoneKey timeZoneKey, boolean legacyTimestamp) {
        this.parseDecimalLiteralAsDouble = parseDecimalLiteralAsDouble;
        this.legacyRowFieldOrdinalAccessEnabled = legacyRowFieldOrdinalAccessEnabled;
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.legacyTimestamp = legacyTimestamp;
    }

    public boolean isParseDecimalLiteralAsDouble() {
        return this.parseDecimalLiteralAsDouble;
    }

    public boolean isLegacyRowFieldOrdinalAccessEnabled() {
        return this.legacyRowFieldOrdinalAccessEnabled;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    @Deprecated
    public boolean isLegacyTimestamp() {
        return this.legacyTimestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlFunctionProperties)) {
            return false;
        }
        SqlFunctionProperties that = (SqlFunctionProperties)o;
        return Objects.equals(this.parseDecimalLiteralAsDouble, that.parseDecimalLiteralAsDouble) && Objects.equals(this.legacyRowFieldOrdinalAccessEnabled, that.legacyRowFieldOrdinalAccessEnabled) && Objects.equals(this.timeZoneKey, that.timeZoneKey) && Objects.equals(this.legacyTimestamp, that.legacyTimestamp);
    }

    public int hashCode() {
        return Objects.hash(this.parseDecimalLiteralAsDouble, this.legacyRowFieldOrdinalAccessEnabled, this.timeZoneKey, this.legacyTimestamp);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean parseDecimalLiteralAsDouble;
        private boolean legacyRowFieldOrdinalAccessEnabled;
        private TimeZoneKey timeZoneKey;
        private boolean legacyTimestamp;

        private Builder() {
        }

        public Builder setParseDecimalLiteralAsDouble(boolean parseDecimalLiteralAsDouble) {
            this.parseDecimalLiteralAsDouble = parseDecimalLiteralAsDouble;
            return this;
        }

        public Builder setLegacyRowFieldOrdinalAccessEnabled(boolean legacyRowFieldOrdinalAccessEnabled) {
            this.legacyRowFieldOrdinalAccessEnabled = legacyRowFieldOrdinalAccessEnabled;
            return this;
        }

        public Builder setTimeZoneKey(TimeZoneKey timeZoneKey) {
            this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
            return this;
        }

        public Builder setLegacyTimestamp(boolean legacyTimestamp) {
            this.legacyTimestamp = legacyTimestamp;
            return this;
        }

        public SqlFunctionProperties build() {
            return new SqlFunctionProperties(this.parseDecimalLiteralAsDouble, this.legacyRowFieldOrdinalAccessEnabled, this.timeZoneKey, this.legacyTimestamp);
        }
    }
}

