/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.security;

import com.facebook.presto.jdbc.internal.spi.CatalogSchemaName;
import com.facebook.presto.jdbc.internal.spi.CatalogSchemaTableName;
import com.facebook.presto.jdbc.internal.spi.SchemaTableName;
import com.facebook.presto.jdbc.internal.spi.security.AccessControlContext;
import com.facebook.presto.jdbc.internal.spi.security.AccessDeniedException;
import com.facebook.presto.jdbc.internal.spi.security.Identity;
import com.facebook.presto.jdbc.internal.spi.security.PrestoPrincipal;
import com.facebook.presto.jdbc.internal.spi.security.Privilege;
import java.security.Principal;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public interface SystemAccessControl {
    public void checkCanSetUser(AccessControlContext var1, Optional<Principal> var2, String var3);

    public void checkQueryIntegrity(Identity var1, AccessControlContext var2, String var3);

    public void checkCanSetSystemSessionProperty(Identity var1, AccessControlContext var2, String var3);

    default public void checkCanAccessCatalog(Identity identity, AccessControlContext context, String catalogName) {
        AccessDeniedException.denyCatalogAccess(catalogName);
    }

    default public Set<String> filterCatalogs(Identity identity, AccessControlContext context, Set<String> catalogs) {
        return Collections.emptySet();
    }

    default public void checkCanCreateSchema(Identity identity, AccessControlContext context, CatalogSchemaName schema) {
        AccessDeniedException.denyCreateSchema(schema.toString());
    }

    default public void checkCanDropSchema(Identity identity, AccessControlContext context, CatalogSchemaName schema) {
        AccessDeniedException.denyDropSchema(schema.toString());
    }

    default public void checkCanRenameSchema(Identity identity, AccessControlContext context, CatalogSchemaName schema, String newSchemaName) {
        AccessDeniedException.denyRenameSchema(schema.toString(), newSchemaName);
    }

    default public void checkCanShowSchemas(Identity identity, AccessControlContext context, String catalogName) {
        AccessDeniedException.denyShowSchemas();
    }

    default public Set<String> filterSchemas(Identity identity, AccessControlContext context, String catalogName, Set<String> schemaNames) {
        return Collections.emptySet();
    }

    default public void checkCanCreateTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyCreateTable(table.toString());
    }

    default public void checkCanDropTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyDropTable(table.toString());
    }

    default public void checkCanRenameTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table, CatalogSchemaTableName newTable) {
        AccessDeniedException.denyRenameTable(table.toString(), newTable.toString());
    }

    default public void checkCanShowTablesMetadata(Identity identity, AccessControlContext context, CatalogSchemaName schema) {
        AccessDeniedException.denyShowTablesMetadata(schema.toString());
    }

    default public Set<SchemaTableName> filterTables(Identity identity, AccessControlContext context, String catalogName, Set<SchemaTableName> tableNames) {
        return Collections.emptySet();
    }

    default public void checkCanAddColumn(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyAddColumn(table.toString());
    }

    default public void checkCanDropColumn(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyDropColumn(table.toString());
    }

    default public void checkCanRenameColumn(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyRenameColumn(table.toString());
    }

    default public void checkCanSelectFromColumns(Identity identity, AccessControlContext context, CatalogSchemaTableName table, Set<String> columns) {
        AccessDeniedException.denySelectColumns(table.toString(), columns);
    }

    default public void checkCanInsertIntoTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyInsertTable(table.toString());
    }

    default public void checkCanDeleteFromTable(Identity identity, AccessControlContext context, CatalogSchemaTableName table) {
        AccessDeniedException.denyDeleteTable(table.toString());
    }

    default public void checkCanCreateView(Identity identity, AccessControlContext context, CatalogSchemaTableName view) {
        AccessDeniedException.denyCreateView(view.toString());
    }

    default public void checkCanDropView(Identity identity, AccessControlContext context, CatalogSchemaTableName view) {
        AccessDeniedException.denyDropView(view.toString());
    }

    default public void checkCanCreateViewWithSelectFromColumns(Identity identity, AccessControlContext context, CatalogSchemaTableName table, Set<String> columns) {
        AccessDeniedException.denyCreateViewWithSelect(table.toString(), identity);
    }

    default public void checkCanSetCatalogSessionProperty(Identity identity, AccessControlContext context, String catalogName, String propertyName) {
        AccessDeniedException.denySetCatalogSessionProperty(propertyName);
    }

    default public void checkCanGrantTablePrivilege(Identity identity, AccessControlContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal grantee, boolean withGrantOption) {
        AccessDeniedException.denyGrantTablePrivilege(privilege.toString(), table.toString());
    }

    default public void checkCanRevokeTablePrivilege(Identity identity, AccessControlContext context, Privilege privilege, CatalogSchemaTableName table, PrestoPrincipal revokee, boolean grantOptionFor) {
        AccessDeniedException.denyRevokeTablePrivilege(privilege.toString(), table.toString());
    }
}

