/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.function.SqlFunctionProperties;
import com.facebook.presto.jdbc.internal.spi.type.AbstractLongType;
import com.facebook.presto.jdbc.internal.spi.type.DateTimeEncoding;
import com.facebook.presto.jdbc.internal.spi.type.SqlTimeWithTimeZone;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignature;

public final class TimeWithTimeZoneType
extends AbstractLongType {
    public static final TimeWithTimeZoneType TIME_WITH_TIME_ZONE = new TimeWithTimeZoneType();

    private TimeWithTimeZoneType() {
        super(TypeSignature.parseTypeSignature("time with time zone"));
    }

    @Override
    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return new SqlTimeWithTimeZone(block.getLong(position));
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        long rightValue;
        long leftValue = DateTimeEncoding.unpackMillisUtc(leftBlock.getLong(leftPosition));
        return leftValue == (rightValue = DateTimeEncoding.unpackMillisUtc(rightBlock.getLong(rightPosition)));
    }

    @Override
    public long hash(Block block, int position) {
        return AbstractLongType.hash(DateTimeEncoding.unpackMillisUtc(block.getLong(position)));
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        long leftValue = DateTimeEncoding.unpackMillisUtc(leftBlock.getLong(leftPosition));
        long rightValue = DateTimeEncoding.unpackMillisUtc(rightBlock.getLong(rightPosition));
        return Long.compare(leftValue, rightValue);
    }

    @Override
    public boolean equals(Object other) {
        return other == TIME_WITH_TIME_ZONE;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

