/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.type;

import com.facebook.presto.jdbc.internal.io.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.spi.block.AbstractArrayBlock;
import com.facebook.presto.jdbc.internal.spi.block.ArrayBlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.Block;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.spi.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.spi.function.SqlFunctionProperties;
import com.facebook.presto.jdbc.internal.spi.type.AbstractType;
import com.facebook.presto.jdbc.internal.spi.type.Type;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignature;
import com.facebook.presto.jdbc.internal.spi.type.TypeSignatureParameter;
import com.facebook.presto.jdbc.internal.spi.type.TypeUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

public class ArrayType
extends AbstractType {
    private final Type elementType;
    public static final String ARRAY_NULL_ELEMENT_MSG = "ARRAY comparison not supported for arrays with null elements";

    public ArrayType(Type elementType) {
        super(new TypeSignature("array", TypeSignatureParameter.of(elementType.getTypeSignature())), Block.class);
        this.elementType = Objects.requireNonNull(elementType, "elementType is null");
    }

    public Type getElementType() {
        return this.elementType;
    }

    @Override
    public boolean isComparable() {
        return this.elementType.isComparable();
    }

    @Override
    public boolean isOrderable() {
        return this.elementType.isOrderable();
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        Block leftArray = leftBlock.getBlock(leftPosition);
        Block rightArray = rightBlock.getBlock(rightPosition);
        if (leftArray.getPositionCount() != rightArray.getPositionCount()) {
            return false;
        }
        for (int i = 0; i < leftArray.getPositionCount(); ++i) {
            TypeUtils.checkElementNotNull(leftArray.isNull(i), ARRAY_NULL_ELEMENT_MSG);
            TypeUtils.checkElementNotNull(rightArray.isNull(i), ARRAY_NULL_ELEMENT_MSG);
            if (this.elementType.equalTo(leftArray, i, rightArray, i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public long hash(Block block, int position) {
        Block array = this.getObject(block, position);
        long hash = 0L;
        for (int i = 0; i < array.getPositionCount(); ++i) {
            hash = 31L * hash + TypeUtils.hashPosition(this.elementType, array, i);
        }
        return hash;
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        int index;
        if (!this.elementType.isOrderable()) {
            throw new UnsupportedOperationException(this.getTypeSignature() + " type is not orderable");
        }
        Block leftArray = leftBlock.getBlock(leftPosition);
        Block rightArray = rightBlock.getBlock(rightPosition);
        int len = Math.min(leftArray.getPositionCount(), rightArray.getPositionCount());
        for (index = 0; index < len; ++index) {
            TypeUtils.checkElementNotNull(leftArray.isNull(index), ARRAY_NULL_ELEMENT_MSG);
            TypeUtils.checkElementNotNull(rightArray.isNull(index), ARRAY_NULL_ELEMENT_MSG);
            int comparison = this.elementType.compareTo(leftArray, index, rightArray, index);
            if (comparison == 0) continue;
            return comparison;
        }
        if (index == len) {
            return leftArray.getPositionCount() - rightArray.getPositionCount();
        }
        return 0;
    }

    @Override
    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        if (block instanceof AbstractArrayBlock) {
            return ((AbstractArrayBlock)block).apply((valuesBlock, start, length) -> this.arrayBlockToObjectValues(properties, valuesBlock, start, length), position);
        }
        Block arrayBlock = block.getBlock(position);
        return this.arrayBlockToObjectValues(properties, arrayBlock, 0, arrayBlock.getPositionCount());
    }

    private List<Object> arrayBlockToObjectValues(SqlFunctionProperties properties, Block block, int start, int length) {
        ArrayList<Object> values = new ArrayList<Object>(length);
        for (int i = 0; i < length; ++i) {
            values.add(this.elementType.getObjectValue(properties, block, i + start));
        }
        return Collections.unmodifiableList(values);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writePositionTo(position, blockBuilder);
        }
    }

    @Override
    public Slice getSlice(Block block, int position) {
        return block.getSlice(position, 0, block.getSliceLength(position));
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value) {
        this.writeSlice(blockBuilder, value, 0, value.length());
    }

    @Override
    public void writeSlice(BlockBuilder blockBuilder, Slice value, int offset, int length) {
        blockBuilder.writeBytes(value, offset, length).closeEntry();
    }

    @Override
    public Block getObject(Block block, int position) {
        return block.getBlock(position);
    }

    @Override
    public Block getBlockUnchecked(Block block, int internalPosition) {
        return block.getBlockUnchecked(internalPosition);
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        blockBuilder.appendStructure((Block)value);
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new ArrayBlockBuilder(this.elementType, blockBuilderStatus, expectedEntries, expectedBytesPerEntry);
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 100);
    }

    @Override
    public List<Type> getTypeParameters() {
        return Collections.singletonList(this.getElementType());
    }

    @Override
    public String getDisplayName() {
        return "array(" + this.elementType.getDisplayName() + ")";
    }
}

