/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.connector.classloader;

import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.spi.BucketFunction;
import com.facebook.presto.jdbc.internal.spi.ConnectorSession;
import com.facebook.presto.jdbc.internal.spi.ConnectorSplit;
import com.facebook.presto.jdbc.internal.spi.Node;
import com.facebook.presto.jdbc.internal.spi.classloader.ThreadContextClassLoader;
import com.facebook.presto.jdbc.internal.spi.connector.ConnectorBucketNodeMap;
import com.facebook.presto.jdbc.internal.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.jdbc.internal.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.jdbc.internal.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.jdbc.internal.spi.connector.ConnectorTransactionHandle;
import java.util.List;
import java.util.Objects;
import java.util.function.ToIntFunction;

public final class ClassLoaderSafeNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final ConnectorNodePartitioningProvider delegate;
    private final ClassLoader classLoader;

    public ClassLoaderSafeNodePartitioningProvider(ConnectorNodePartitioningProvider delegate, ClassLoader classLoader) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.classLoader = Objects.requireNonNull(classLoader, "classLoader is null");
    }

    @Override
    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            BucketFunction bucketFunction = this.delegate.getBucketFunction(transactionHandle, session, partitioningHandle, partitionChannelTypes, bucketCount);
            return bucketFunction;
        }
    }

    @Override
    public List<ConnectorPartitionHandle> listPartitionHandles(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            List<ConnectorPartitionHandle> list = this.delegate.listPartitionHandles(transactionHandle, session, partitioningHandle);
            return list;
        }
    }

    @Override
    public ConnectorBucketNodeMap getBucketNodeMap(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Node> sortedNodes) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ConnectorBucketNodeMap connectorBucketNodeMap = this.delegate.getBucketNodeMap(transactionHandle, session, partitioningHandle, sortedNodes);
            return connectorBucketNodeMap;
        }
    }

    @Override
    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.classLoader);){
            ToIntFunction<ConnectorSplit> toIntFunction = this.delegate.getSplitBucketFunction(transactionHandle, session, partitioningHandle);
            return toIntFunction;
        }
    }
}

