/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.GenericInternalException;
import com.facebook.presto.jdbc.internal.common.NotSupportedException;
import com.facebook.presto.jdbc.internal.common.block.AbstractMapBlock;
import com.facebook.presto.jdbc.internal.common.block.AbstractSingleMapBlock;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.MapBlockBuilder;
import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.javax.annotation.Nullable;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import java.util.function.BiConsumer;

public class SingleMapBlock
extends AbstractSingleMapBlock {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleMapBlock.class).instanceSize();
    private final int offset;
    private final int positionCount;
    private final AbstractMapBlock mapBlock;

    SingleMapBlock(int offset, int positionCount, AbstractMapBlock mapBlock) {
        this.offset = offset;
        this.positionCount = positionCount;
        this.mapBlock = mapBlock;
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getSizeInBytes() {
        return this.mapBlock.getRawKeyBlock().getRegionSizeInBytes(this.offset / 2, this.positionCount / 2) + this.mapBlock.getRawValueBlock().getRegionSizeInBytes(this.offset / 2, this.positionCount / 2) + SizeOf.sizeOfIntArray(this.positionCount / 2 * 2);
    }

    @Override
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.mapBlock.getRawKeyBlock().getRetainedSizeInBytes() + this.mapBlock.getRawValueBlock().getRetainedSizeInBytes() + this.mapBlock.getHashTables().getRetainedSizeInBytes();
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.mapBlock.getRawKeyBlock(), this.mapBlock.getRawKeyBlock().getRetainedSizeInBytes());
        consumer.accept(this.mapBlock.getRawValueBlock(), this.mapBlock.getRawValueBlock().getRetainedSizeInBytes());
        consumer.accept(this.mapBlock.getHashTables(), this.mapBlock.getHashTables().getRetainedSizeInBytes());
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public String getEncodingName() {
        return "MAP_ELEMENT";
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    Block getRawKeyBlock() {
        return this.mapBlock.getRawKeyBlock();
    }

    @Override
    Block getRawValueBlock() {
        return this.mapBlock.getRawValueBlock();
    }

    public String toString() {
        return String.format("SingleMapBlock{positionCount=%d}", this.getPositionCount());
    }

    @Override
    public Block getLoadedBlock() {
        if (this.mapBlock.getRawKeyBlock() != this.mapBlock.getRawKeyBlock().getLoadedBlock()) {
            throw new IllegalStateException();
        }
        Block loadedValueBlock = this.mapBlock.getRawValueBlock().getLoadedBlock();
        if (loadedValueBlock == this.mapBlock.getRawValueBlock()) {
            return this;
        }
        return new SingleMapBlock(this.offset, this.positionCount, this.mapBlock);
    }

    @Override
    public Block appendNull() {
        throw new UnsupportedOperationException("SingleMapBlock does not support appendNull()");
    }

    @Nullable
    int[] getHashTable() {
        return this.mapBlock.getHashTables().get();
    }

    Type getKeyType() {
        return this.mapBlock.keyType;
    }

    public int seekKey(Object nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        this.mapBlock.ensureHashTableLoaded();
        int[] hashTable = this.mapBlock.getHashTables().get();
        try {
            hashCode = this.mapBlock.keyNativeHashCode.invoke(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int position = MapBlockBuilder.computePosition(hashCode, hashTableSize);
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            try {
                match = this.mapBlock.keyBlockNativeEquals.invoke(this.mapBlock.getRawKeyBlock(), this.offset / 2 + keyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            SingleMapBlock.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition * 2 + 1;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    public int seekKeyExact(long nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        this.mapBlock.ensureHashTableLoaded();
        int[] hashTable = this.mapBlock.getHashTables().get();
        try {
            hashCode = this.mapBlock.keyNativeHashCode.invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int position = MapBlockBuilder.computePosition(hashCode, hashTableSize);
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            try {
                match = this.mapBlock.keyBlockNativeEquals.invokeExact(this.mapBlock.getRawKeyBlock(), this.offset / 2 + keyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            SingleMapBlock.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition * 2 + 1;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    public int seekKeyExact(boolean nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        this.mapBlock.ensureHashTableLoaded();
        int[] hashTable = this.mapBlock.getHashTables().get();
        try {
            hashCode = this.mapBlock.keyNativeHashCode.invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int position = MapBlockBuilder.computePosition(hashCode, hashTableSize);
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            try {
                match = this.mapBlock.keyBlockNativeEquals.invokeExact(this.mapBlock.getRawKeyBlock(), this.offset / 2 + keyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            SingleMapBlock.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition * 2 + 1;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    public int seekKeyExact(double nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        this.mapBlock.ensureHashTableLoaded();
        int[] hashTable = this.mapBlock.getHashTables().get();
        try {
            hashCode = this.mapBlock.keyNativeHashCode.invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int position = MapBlockBuilder.computePosition(hashCode, hashTableSize);
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            try {
                match = this.mapBlock.keyBlockNativeEquals.invokeExact(this.mapBlock.getRawKeyBlock(), this.offset / 2 + keyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            SingleMapBlock.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition * 2 + 1;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    public int seekKeyExact(Slice nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        this.mapBlock.ensureHashTableLoaded();
        int[] hashTable = this.mapBlock.getHashTables().get();
        try {
            hashCode = this.mapBlock.keyNativeHashCode.invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int position = MapBlockBuilder.computePosition(hashCode, hashTableSize);
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            try {
                Block rawKeyBlock = this.mapBlock.getRawKeyBlock();
                match = rawKeyBlock.getSliceLength(this.offset / 2 + keyPosition) != nativeValue.length() ? Boolean.valueOf(false) : Boolean.valueOf(rawKeyBlock.bytesEqual(this.offset / 2 + keyPosition, 0, nativeValue, 0, nativeValue.length()));
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            SingleMapBlock.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition * 2 + 1;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    public int seekKeyExact(Block nativeValue) {
        long hashCode;
        if (this.positionCount == 0) {
            return -1;
        }
        this.mapBlock.ensureHashTableLoaded();
        int[] hashTable = this.mapBlock.getHashTables().get();
        try {
            hashCode = this.mapBlock.keyNativeHashCode.invokeExact(nativeValue);
        }
        catch (Throwable throwable) {
            throw SingleMapBlock.handleThrowable(throwable);
        }
        int hashTableOffset = this.offset / 2 * 2;
        int hashTableSize = this.positionCount / 2 * 2;
        int position = MapBlockBuilder.computePosition(hashCode, hashTableSize);
        int keyPosition;
        while ((keyPosition = hashTable[hashTableOffset + position]) != -1) {
            Boolean match;
            try {
                match = this.mapBlock.keyBlockNativeEquals.invokeExact(this.mapBlock.getRawKeyBlock(), this.offset / 2 + keyPosition, nativeValue);
            }
            catch (Throwable throwable) {
                throw SingleMapBlock.handleThrowable(throwable);
            }
            SingleMapBlock.checkNotIndeterminate(match);
            if (match.booleanValue()) {
                return keyPosition * 2 + 1;
            }
            if (++position != hashTableSize) continue;
            position = 0;
        }
        return -1;
    }

    private static RuntimeException handleThrowable(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        throw new GenericInternalException(throwable);
    }

    private static void checkNotIndeterminate(Boolean equalsResult) {
        if (equalsResult == null) {
            throw new NotSupportedException("map key cannot be null or contain nulls");
        }
    }
}

