/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.block.AbstractSingleRowBlock;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceInput;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import java.util.function.BiConsumer;

public class SingleRowBlockWriter
extends AbstractSingleRowBlock
implements BlockBuilder {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SingleRowBlockWriter.class).instanceSize();
    private final BlockBuilder[] fieldBlockBuilders;
    private final long initialBlockBuilderSize;
    private int positionsWritten;
    private int currentFieldIndexToWrite;
    private boolean fieldBlockBuilderReturned;

    SingleRowBlockWriter(int rowIndex, BlockBuilder[] fieldBlockBuilders) {
        super(rowIndex);
        this.fieldBlockBuilders = fieldBlockBuilders;
        long initialBlockBuilderSize = 0L;
        for (BlockBuilder fieldBlockBuilder : fieldBlockBuilders) {
            initialBlockBuilderSize += fieldBlockBuilder.getSizeInBytes();
        }
        this.initialBlockBuilderSize = initialBlockBuilderSize;
    }

    public BlockBuilder getFieldBlockBuilder(int fieldIndex) {
        if (this.currentFieldIndexToWrite != 0) {
            throw new IllegalStateException("field block builder can only be obtained before any sequential write has done");
        }
        this.fieldBlockBuilderReturned = true;
        return this.fieldBlockBuilders[fieldIndex];
    }

    @Override
    protected Block getRawFieldBlock(int fieldIndex) {
        return this.fieldBlockBuilders[fieldIndex];
    }

    @Override
    public long getSizeInBytes() {
        long currentBlockBuilderSize = 0L;
        for (BlockBuilder fieldBlockBuilder : this.fieldBlockBuilders) {
            currentBlockBuilderSize += fieldBlockBuilder.getSizeInBytes();
        }
        return currentBlockBuilderSize - this.initialBlockBuilderSize;
    }

    @Override
    public long getRetainedSizeInBytes() {
        long size = INSTANCE_SIZE;
        for (BlockBuilder fieldBlockBuilder : this.fieldBlockBuilders) {
            size += fieldBlockBuilder.getRetainedSizeInBytes();
        }
        return size;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        for (BlockBuilder fieldBlockBuilder : this.fieldBlockBuilders) {
            consumer.accept(fieldBlockBuilder, fieldBlockBuilder.getRetainedSizeInBytes());
        }
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public BlockBuilder writeByte(int value) {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].writeByte(value);
        return this;
    }

    @Override
    public BlockBuilder writeShort(int value) {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].writeShort(value);
        return this;
    }

    @Override
    public BlockBuilder writeInt(int value) {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].writeInt(value);
        return this;
    }

    @Override
    public BlockBuilder writeLong(long value) {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].writeLong(value);
        return this;
    }

    @Override
    public BlockBuilder writeBytes(Slice source, int sourceIndex, int length) {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].writeBytes(source, sourceIndex, length);
        return this;
    }

    @Override
    public BlockBuilder appendStructure(Block block) {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].appendStructure(block);
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder appendStructureInternal(Block block, int position) {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].appendStructureInternal(block, position);
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder beginBlockEntry() {
        this.checkFieldIndexToWrite();
        return this.fieldBlockBuilders[this.currentFieldIndexToWrite].beginBlockEntry();
    }

    @Override
    public BlockBuilder appendNull() {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].appendNull();
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder closeEntry() {
        this.checkFieldIndexToWrite();
        this.fieldBlockBuilders[this.currentFieldIndexToWrite].closeEntry();
        this.entryAdded();
        return this;
    }

    @Override
    public BlockBuilder readPositionFrom(SliceInput input) {
        boolean isNull;
        boolean bl = isNull = input.readByte() == 0;
        if (isNull) {
            this.appendNull();
        } else {
            this.checkFieldIndexToWrite();
            this.fieldBlockBuilders[this.currentFieldIndexToWrite].readPositionFrom(input);
            this.entryAdded();
        }
        return this;
    }

    private void entryAdded() {
        ++this.currentFieldIndexToWrite;
        ++this.positionsWritten;
    }

    @Override
    public int getPositionCount() {
        if (this.fieldBlockBuilderReturned) {
            throw new IllegalStateException("field block builder has been returned");
        }
        return this.positionsWritten;
    }

    @Override
    public String getEncodingName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Block build() {
        throw new UnsupportedOperationException();
    }

    @Override
    public BlockBuilder newBlockBuilderLike(BlockBuilderStatus blockBuilderStatus) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        if (!this.fieldBlockBuilderReturned) {
            return String.format("SingleRowBlockWriter{numFields=%d, fieldBlockBuilderReturned=false, positionCount=%d}", this.fieldBlockBuilders.length, this.getPositionCount());
        }
        return String.format("SingleRowBlockWriter{numFields=%d, fieldBlockBuilderReturned=true}", this.fieldBlockBuilders.length);
    }

    private void checkFieldIndexToWrite() {
        if (this.fieldBlockBuilderReturned) {
            throw new IllegalStateException("cannot do sequential write after getFieldBlockBuilder is called");
        }
        if (this.currentFieldIndexToWrite >= this.fieldBlockBuilders.length) {
            throw new IllegalStateException("currentFieldIndexToWrite is not valid");
        }
    }
}

