/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.client;

import com.facebook.presto.jdbc.internal.client.ClientException;
import com.facebook.presto.jdbc.internal.client.GCSOAuthScope;
import com.facebook.presto.jdbc.internal.google.auth.oauth2.AccessToken;
import com.facebook.presto.jdbc.internal.google.auth.oauth2.GoogleCredentials;
import com.facebook.presto.jdbc.internal.guava.base.Splitter;
import com.facebook.presto.jdbc.internal.okhttp3.Interceptor;
import com.facebook.presto.jdbc.internal.okhttp3.Request;
import com.facebook.presto.jdbc.internal.okhttp3.Response;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class GCSOAuthInterceptor
implements Interceptor {
    public static final String GCS_CREDENTIALS_PATH_KEY = "hive.gcs.credentials.path";
    public static final String GCS_OAUTH_SCOPES_KEY = "hive.gcs.oauth.scopes";
    private static final String GCS_CREDENTIALS_OAUTH_TOKEN_KEY = "hive.gcs.oauth";
    private static final Splitter SCOPE_SPLITTER = Splitter.on("|");
    private final Collection<String> gcsOAuthScopeURLs;
    private final String credentialsFilePath;
    private GoogleCredentials credentials;

    public GCSOAuthInterceptor(String credentialPath, Optional<String> gcsOAuthScopesString) {
        this.credentialsFilePath = Objects.requireNonNull(credentialPath);
        this.gcsOAuthScopeURLs = this.mapScopeStringToURLs(Objects.requireNonNull(gcsOAuthScopesString).orElse(GCSOAuthScope.DEVSTORAGE_READ_ONLY.name()));
    }

    @Override
    public Response intercept(Interceptor.Chain chain) throws IOException {
        return chain.proceed(this.attachGCSAccessToken(chain.request()));
    }

    private Request attachGCSAccessToken(Request request) {
        AccessToken token = this.getCredentials().getAccessToken();
        return request.newBuilder().addHeader("X-Presto-Extra-Credential", "hive.gcs.oauth=" + token.getTokenValue()).build();
    }

    private synchronized GoogleCredentials getCredentials() {
        if (this.credentials == null) {
            this.credentials = this.createCredentials();
        }
        try {
            this.credentials.refreshIfExpired();
        }
        catch (IOException e) {
            throw new ClientException("Google credential refreshing error", e);
        }
        return this.credentials;
    }

    private GoogleCredentials createCredentials() {
        try {
            return GoogleCredentials.fromStream(new FileInputStream(this.credentialsFilePath)).createScoped(this.gcsOAuthScopeURLs);
        }
        catch (IOException e) {
            throw new ClientException("Google credential loading error", e);
        }
    }

    private Collection<String> mapScopeStringToURLs(String gcsOAuthScopesString) {
        return StreamSupport.stream(SCOPE_SPLITTER.split(gcsOAuthScopesString).spliterator(), false).map(GCSOAuthScope::valueOf).map(scope -> scope.getScopeURL()).collect(Collectors.toList());
    }
}

