/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.type.AbstractVarcharType;
import com.facebook.presto.jdbc.internal.common.type.EnumType;
import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;
import com.facebook.presto.jdbc.internal.common.type.TypeSignatureParameter;
import com.facebook.presto.jdbc.internal.common.type.TypeUtils;
import com.facebook.presto.jdbc.internal.common.type.VarcharType;
import com.facebook.presto.jdbc.internal.common.type.encoding.Base32;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class VarcharEnumType
extends AbstractVarcharType
implements EnumType<String> {
    private final VarcharEnumMap enumMap;

    public VarcharEnumType(String name, VarcharEnumMap enumMap) {
        super(Integer.MAX_VALUE, new TypeSignature(name, TypeSignatureParameter.of(enumMap)));
        this.enumMap = enumMap;
    }

    @Override
    public Map<String, String> getEnumMap() {
        return this.enumMap.getEnumMap();
    }

    @Override
    public Type getValueType() {
        return VarcharType.VARCHAR;
    }

    @Override
    public String getDisplayName() {
        return this.getTypeSignature().getBase();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getTypeSignature().getBase(), this.enumMap);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VarcharEnumType other = (VarcharEnumType)o;
        return Objects.equals(this.getTypeSignature().getBase(), other.getTypeSignature().getBase()) && Objects.equals(this.getEnumMap(), other.getEnumMap());
    }

    public static class VarcharEnumMap {
        private final Map<String, String> enumMap;

        @JsonCreator
        public VarcharEnumMap(@JsonProperty(value="enumMap") Map<String, String> enumMap) {
            TypeUtils.validateEnumMap(enumMap);
            this.enumMap = TypeUtils.normalizeEnumMap(enumMap);
        }

        @JsonProperty
        public Map<String, String> getEnumMap() {
            return this.enumMap;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VarcharEnumMap other = (VarcharEnumMap)o;
            return Objects.equals(this.enumMap, other.enumMap);
        }

        public String toString() {
            Base32 base32 = new Base32();
            return "enum:varchar{" + this.enumMap.entrySet().stream().sorted(Comparator.comparing(Map.Entry::getKey)).map(e -> String.format("\"%s\": \"%s\"", ((String)e.getKey()).replaceAll("\"", "\"\""), base32.encodeAsString(((String)e.getValue()).getBytes()))).collect(Collectors.joining(", ")) + "}";
        }

        public int hashCode() {
            return Objects.hash(this.enumMap);
        }
    }
}

