/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.page;

import com.facebook.presto.jdbc.internal.io.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import com.facebook.presto.jdbc.internal.spi.page.PageCodecMarker;
import java.util.Objects;

public class SerializedPage {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(SerializedPage.class).instanceSize();
    private final Slice slice;
    private final int positionCount;
    private final int uncompressedSizeInBytes;
    private final byte pageCodecMarkers;

    public SerializedPage(Slice slice, byte pageCodecMarkers, int positionCount, int uncompressedSizeInBytes) {
        this.slice = Objects.requireNonNull(slice, "slice is null");
        this.positionCount = positionCount;
        SerializedPage.checkArgument(uncompressedSizeInBytes >= 0, "uncompressedSizeInBytes is negative", new Object[0]);
        this.uncompressedSizeInBytes = uncompressedSizeInBytes;
        this.pageCodecMarkers = pageCodecMarkers;
        if (!PageCodecMarker.ENCRYPTED.isSet(pageCodecMarkers)) {
            if (PageCodecMarker.COMPRESSED.isSet(pageCodecMarkers)) {
                SerializedPage.checkArgument(uncompressedSizeInBytes > slice.length(), "compressed size must be smaller than uncompressed size when compressed", new Object[0]);
            } else {
                SerializedPage.checkArgument(uncompressedSizeInBytes == slice.length(), "uncompressed size must be equal to slice length when uncompressed", new Object[0]);
            }
        }
    }

    public byte getPageCodecMarkers() {
        return this.pageCodecMarkers;
    }

    public int getPositionCount() {
        return this.positionCount;
    }

    public int getUncompressedSizeInBytes() {
        return this.uncompressedSizeInBytes;
    }

    public int getSizeInBytes() {
        return this.slice.length();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + this.slice.getRetainedSize();
    }

    public Slice getSlice() {
        return this.slice;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SerializedPage that = (SerializedPage)o;
        return Objects.equals(this.slice, that.slice) && Objects.equals(this.positionCount, that.positionCount) && Objects.equals(this.uncompressedSizeInBytes, that.uncompressedSizeInBytes) && Objects.equals(this.pageCodecMarkers, that.pageCodecMarkers);
    }

    public int hashCode() {
        return Objects.hash(this.slice, this.positionCount, this.uncompressedSizeInBytes, this.pageCodecMarkers);
    }

    private static void checkArgument(boolean condition, String message, Object ... messageArgs) {
        if (!condition) {
            throw new IllegalArgumentException(String.format(message, messageArgs));
        }
    }
}

