/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.function;

import com.facebook.presto.jdbc.internal.common.QualifiedObjectName;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SqlFunctionId {
    private final QualifiedObjectName functionName;
    private final List<TypeSignature> argumentTypes;

    @JsonCreator
    public SqlFunctionId(@JsonProperty(value="functionName") QualifiedObjectName functionName, @JsonProperty(value="argumentTypes") List<TypeSignature> argumentTypes) {
        this.functionName = Objects.requireNonNull(functionName, "functionName is null");
        this.argumentTypes = Objects.requireNonNull(argumentTypes, "argumentTypes is null");
    }

    @JsonProperty
    public QualifiedObjectName getFunctionName() {
        return this.functionName;
    }

    @JsonProperty
    public List<TypeSignature> getArgumentTypes() {
        return this.argumentTypes;
    }

    public String getId() {
        return this.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlFunctionId o = (SqlFunctionId)obj;
        return Objects.equals(this.functionName, o.functionName) && Objects.equals(this.argumentTypes, o.argumentTypes);
    }

    public int hashCode() {
        return Objects.hash(this.functionName, this.argumentTypes);
    }

    public String toString() {
        String arguments = this.argumentTypes.stream().map(Object::toString).collect(Collectors.joining(", "));
        return String.format("%s(%s)", this.functionName, arguments);
    }
}

