/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.GenericInternalException;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.function.SqlFunctionProperties;
import com.facebook.presto.jdbc.internal.common.type.AbstractIntType;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;

public final class RealType
extends AbstractIntType {
    public static final RealType REAL = new RealType();

    private RealType() {
        super(TypeSignature.parseTypeSignature("real"));
    }

    @Override
    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return Float.valueOf(Float.intBitsToFloat(block.getInt(position)));
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        float rightValue;
        float leftValue = Float.intBitsToFloat(leftBlock.getInt(leftPosition));
        return leftValue == (rightValue = Float.intBitsToFloat(rightBlock.getInt(rightPosition)));
    }

    @Override
    public long hash(Block block, int position) {
        return RealType.hash(Float.floatToIntBits(Float.intBitsToFloat(block.getInt(position))));
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        float leftValue = Float.intBitsToFloat(leftBlock.getInt(leftPosition));
        float rightValue = Float.intBitsToFloat(rightBlock.getInt(rightPosition));
        return Float.compare(leftValue, rightValue);
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        try {
            Math.toIntExact(value);
        }
        catch (ArithmeticException e) {
            throw new GenericInternalException(String.format("Value (%sb) is not a valid single-precision float", Long.toBinaryString(value).replace(' ', '0')));
        }
        blockBuilder.writeInt((int)value).closeEntry();
    }

    @Override
    public boolean equals(Object other) {
        return other == REAL;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

