/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.block.AbstractMapBlock;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.common.block.MapBlock;
import com.facebook.presto.jdbc.internal.common.block.MapBlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.SingleMapBlock;
import com.facebook.presto.jdbc.internal.common.function.SqlFunctionProperties;
import com.facebook.presto.jdbc.internal.common.type.AbstractType;
import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;
import com.facebook.presto.jdbc.internal.common.type.TypeSignatureParameter;
import com.facebook.presto.jdbc.internal.common.type.TypeUtils;
import java.lang.invoke.MethodHandle;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class MapType
extends AbstractType {
    private final Type keyType;
    private final Type valueType;
    private static final String MAP_NULL_ELEMENT_MSG = "MAP comparison not supported for null value elements";
    private static final int EXPECTED_BYTES_PER_ENTRY = 32;
    private final MethodHandle keyBlockHashCode;
    private final MethodHandle keyBlockEquals;

    public MapType(Type keyType, Type valueType, MethodHandle keyBlockEquals, MethodHandle keyBlockHashCode) {
        super(new TypeSignature("map", TypeSignatureParameter.of(keyType.getTypeSignature()), TypeSignatureParameter.of(valueType.getTypeSignature())), Block.class);
        if (!keyType.isComparable()) {
            throw new IllegalArgumentException(String.format("key type must be comparable, got %s", keyType));
        }
        this.keyType = keyType;
        this.valueType = valueType;
        Objects.requireNonNull(keyBlockHashCode, "keyBlockHashCode is null");
        this.keyBlockHashCode = keyBlockHashCode;
        this.keyBlockEquals = keyBlockEquals;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        return new MapBlockBuilder(this.keyType, this.valueType, this.keyBlockEquals, this.keyBlockHashCode, blockBuilderStatus, expectedEntries);
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 32);
    }

    public Type getKeyType() {
        return this.keyType;
    }

    public Type getValueType() {
        return this.valueType;
    }

    @Override
    public boolean isComparable() {
        return this.valueType.isComparable();
    }

    @Override
    public long hash(Block block, int position) {
        Block mapBlock = this.getObject(block, position);
        long result = 0L;
        for (int i = 0; i < mapBlock.getPositionCount(); i += 2) {
            result += TypeUtils.hashPosition(this.keyType, mapBlock, i) ^ TypeUtils.hashPosition(this.valueType, mapBlock, i + 1);
        }
        return result;
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        int position;
        Block leftMapBlock = leftBlock.getBlock(leftPosition);
        Block rightMapBlock = rightBlock.getBlock(rightPosition);
        if (leftMapBlock.getPositionCount() != rightMapBlock.getPositionCount()) {
            return false;
        }
        HashMap<KeyWrapper, Integer> wrappedLeftMap = new HashMap<KeyWrapper, Integer>();
        for (position = 0; position < leftMapBlock.getPositionCount(); position += 2) {
            wrappedLeftMap.put(new KeyWrapper(this.keyType, leftMapBlock, position), position + 1);
        }
        for (position = 0; position < rightMapBlock.getPositionCount(); position += 2) {
            KeyWrapper key = new KeyWrapper(this.keyType, rightMapBlock, position);
            Integer leftValuePosition = (Integer)wrappedLeftMap.get(key);
            if (leftValuePosition == null) {
                return false;
            }
            int rightValuePosition = position + 1;
            TypeUtils.checkElementNotNull(leftMapBlock.isNull(leftValuePosition), MAP_NULL_ELEMENT_MSG);
            TypeUtils.checkElementNotNull(rightMapBlock.isNull(rightValuePosition), MAP_NULL_ELEMENT_MSG);
            if (this.valueType.equalTo(leftMapBlock, leftValuePosition, rightMapBlock, rightValuePosition)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        Block singleMapBlock = block.getBlock(position);
        if (!(singleMapBlock instanceof SingleMapBlock)) {
            throw new UnsupportedOperationException("Map is encoded with legacy block representation");
        }
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        for (int i = 0; i < singleMapBlock.getPositionCount(); i += 2) {
            map.put(this.keyType.getObjectValue(properties, singleMapBlock, i), this.valueType.getObjectValue(properties, singleMapBlock, i + 1));
        }
        return Collections.unmodifiableMap(map);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            block.writePositionTo(position, blockBuilder);
        }
    }

    @Override
    public Block getObject(Block block, int position) {
        return block.getBlock(position);
    }

    @Override
    public Block getBlockUnchecked(Block block, int internalPosition) {
        return block.getBlockUnchecked(internalPosition);
    }

    @Override
    public void writeObject(BlockBuilder blockBuilder, Object value) {
        if (!(value instanceof SingleMapBlock)) {
            throw new IllegalArgumentException("Maps must be represented with SingleMapBlock");
        }
        blockBuilder.appendStructure((Block)value);
    }

    @Override
    public List<Type> getTypeParameters() {
        return Arrays.asList(this.getKeyType(), this.getValueType());
    }

    @Override
    public String getDisplayName() {
        return "map(" + this.keyType.getDisplayName() + ", " + this.valueType.getDisplayName() + ")";
    }

    public Block createBlockFromKeyValue(int positionCount, Optional<boolean[]> mapIsNull, int[] offsets, Block keyBlock, Block valueBlock) {
        return MapBlock.fromKeyValueBlock(positionCount, mapIsNull, offsets, keyBlock, valueBlock);
    }

    public static Block createMapBlockInternal(int startOffset, int positionCount, Optional<boolean[]> mapIsNull, int[] offsets, Block keyBlock, Block valueBlock, AbstractMapBlock.HashTables hashTables) {
        return MapBlock.createMapBlockInternal(startOffset, positionCount, mapIsNull, offsets, keyBlock, valueBlock, hashTables);
    }

    private static final class KeyWrapper {
        private final Type type;
        private final Block block;
        private final int position;

        public KeyWrapper(Type type, Block block, int position) {
            this.type = type;
            this.block = block;
            this.position = position;
        }

        public Block getBlock() {
            return this.block;
        }

        public int getPosition() {
            return this.position;
        }

        public int hashCode() {
            return Long.hashCode(this.type.hash(this.block, this.position));
        }

        public boolean equals(Object obj) {
            if (obj == null || !this.getClass().equals(obj.getClass())) {
                return false;
            }
            KeyWrapper other = (KeyWrapper)obj;
            return this.type.equalTo(this.block, this.position, other.getBlock(), other.getPosition());
        }
    }
}

