/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc;

import com.facebook.presto.jdbc.StageStats;
import com.facebook.presto.jdbc.internal.client.StatementStats;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;

public final class QueryStats {
    private final String queryId;
    private final String state;
    private final boolean queued;
    private final boolean scheduled;
    private final int nodes;
    private final int totalSplits;
    private final int queuedSplits;
    private final int runningSplits;
    private final int completedSplits;
    private final long cpuTimeMillis;
    private final long wallTimeMillis;
    private final long queuedTimeMillis;
    private final long elapsedTimeMillis;
    private final long processedRows;
    private final long processedBytes;
    private final long peakMemoryBytes;
    private final long peakTotalMemoryBytes;
    private final long peakTaskTotalMemoryBytes;
    private final Optional<StageStats> rootStage;

    public QueryStats(String queryId, String state, boolean queued, boolean scheduled, int nodes, int totalSplits, int queuedSplits, int runningSplits, int completedSplits, long cpuTimeMillis, long wallTimeMillis, long queuedTimeMillis, long elapsedTimeMillis, long processedRows, long processedBytes, long peakMemoryBytes, long peakTotalMemoryBytes, long peakTaskTotalMemoryBytes, Optional<StageStats> rootStage) {
        this.queryId = Objects.requireNonNull(queryId, "queryId is null");
        this.state = Objects.requireNonNull(state, "state is null");
        this.queued = queued;
        this.scheduled = scheduled;
        this.nodes = nodes;
        this.totalSplits = totalSplits;
        this.queuedSplits = queuedSplits;
        this.runningSplits = runningSplits;
        this.completedSplits = completedSplits;
        this.cpuTimeMillis = cpuTimeMillis;
        this.wallTimeMillis = wallTimeMillis;
        this.queuedTimeMillis = queuedTimeMillis;
        this.elapsedTimeMillis = elapsedTimeMillis;
        this.processedRows = processedRows;
        this.processedBytes = processedBytes;
        this.peakMemoryBytes = peakMemoryBytes;
        this.peakTotalMemoryBytes = peakTotalMemoryBytes;
        this.peakTaskTotalMemoryBytes = peakTaskTotalMemoryBytes;
        this.rootStage = Objects.requireNonNull(rootStage, "rootStage is null");
    }

    static QueryStats create(String queryId, StatementStats stats) {
        return new QueryStats(queryId, stats.getState(), stats.isQueued(), stats.isScheduled(), stats.getNodes(), stats.getTotalSplits(), stats.getQueuedSplits(), stats.getRunningSplits(), stats.getCompletedSplits(), stats.getCpuTimeMillis(), stats.getWallTimeMillis(), stats.getQueuedTimeMillis(), stats.getElapsedTimeMillis(), stats.getProcessedRows(), stats.getProcessedBytes(), stats.getPeakMemoryBytes(), stats.getPeakTotalMemoryBytes(), stats.getPeakTaskTotalMemoryBytes(), Optional.ofNullable(stats.getRootStage()).map(StageStats::create));
    }

    public String getQueryId() {
        return this.queryId;
    }

    public String getState() {
        return this.state;
    }

    public boolean isQueued() {
        return this.queued;
    }

    public boolean isScheduled() {
        return this.scheduled;
    }

    public int getNodes() {
        return this.nodes;
    }

    public int getTotalSplits() {
        return this.totalSplits;
    }

    public int getQueuedSplits() {
        return this.queuedSplits;
    }

    public int getRunningSplits() {
        return this.runningSplits;
    }

    public int getCompletedSplits() {
        return this.completedSplits;
    }

    public long getCpuTimeMillis() {
        return this.cpuTimeMillis;
    }

    public long getWallTimeMillis() {
        return this.wallTimeMillis;
    }

    public long getQueuedTimeMillis() {
        return this.queuedTimeMillis;
    }

    public long getElapsedTimeMillis() {
        return this.elapsedTimeMillis;
    }

    public long getProcessedRows() {
        return this.processedRows;
    }

    public long getProcessedBytes() {
        return this.processedBytes;
    }

    public long getPeakMemoryBytes() {
        return this.peakMemoryBytes;
    }

    public long getPeakTotalMemoryBytes() {
        return this.peakTotalMemoryBytes;
    }

    public long getPeakTaskTotalMemoryBytes() {
        return this.peakTaskTotalMemoryBytes;
    }

    public Optional<StageStats> getRootStage() {
        return this.rootStage;
    }

    public OptionalDouble getProgressPercentage() {
        if (!this.scheduled || this.totalSplits == 0) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(Math.min(100.0, (double)this.completedSplits * 100.0 / (double)this.totalSplits));
    }
}

