/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.spi.ErrorCode;
import com.facebook.presto.jdbc.internal.spi.ErrorCodeSupplier;
import com.facebook.presto.jdbc.internal.spi.ErrorType;

public enum StandardErrorCode implements ErrorCodeSupplier
{
    GENERIC_USER_ERROR(0, ErrorType.USER_ERROR),
    SYNTAX_ERROR(1, ErrorType.USER_ERROR),
    ABANDONED_QUERY(2, ErrorType.USER_ERROR),
    USER_CANCELED(3, ErrorType.USER_ERROR),
    PERMISSION_DENIED(4, ErrorType.USER_ERROR),
    NOT_FOUND(5, ErrorType.USER_ERROR),
    FUNCTION_NOT_FOUND(6, ErrorType.USER_ERROR),
    INVALID_FUNCTION_ARGUMENT(7, ErrorType.USER_ERROR),
    DIVISION_BY_ZERO(8, ErrorType.USER_ERROR),
    INVALID_CAST_ARGUMENT(9, ErrorType.USER_ERROR),
    OPERATOR_NOT_FOUND(10, ErrorType.USER_ERROR),
    INVALID_VIEW(11, ErrorType.USER_ERROR),
    ALREADY_EXISTS(12, ErrorType.USER_ERROR),
    NOT_SUPPORTED(13, ErrorType.USER_ERROR),
    INVALID_SESSION_PROPERTY(14, ErrorType.USER_ERROR),
    INVALID_WINDOW_FRAME(15, ErrorType.USER_ERROR),
    CONSTRAINT_VIOLATION(16, ErrorType.USER_ERROR),
    TRANSACTION_CONFLICT(17, ErrorType.USER_ERROR),
    INVALID_TABLE_PROPERTY(18, ErrorType.USER_ERROR),
    NUMERIC_VALUE_OUT_OF_RANGE(19, ErrorType.USER_ERROR),
    UNKNOWN_TRANSACTION(20, ErrorType.USER_ERROR),
    NOT_IN_TRANSACTION(21, ErrorType.USER_ERROR),
    TRANSACTION_ALREADY_ABORTED(22, ErrorType.USER_ERROR),
    READ_ONLY_VIOLATION(23, ErrorType.USER_ERROR),
    MULTI_CATALOG_WRITE_CONFLICT(24, ErrorType.USER_ERROR),
    AUTOCOMMIT_WRITE_CONFLICT(25, ErrorType.USER_ERROR),
    UNSUPPORTED_ISOLATION_LEVEL(26, ErrorType.USER_ERROR),
    INCOMPATIBLE_CLIENT(27, ErrorType.USER_ERROR),
    SUBQUERY_MULTIPLE_ROWS(28, ErrorType.USER_ERROR),
    PROCEDURE_NOT_FOUND(29, ErrorType.USER_ERROR),
    INVALID_PROCEDURE_ARGUMENT(30, ErrorType.USER_ERROR),
    QUERY_REJECTED(31, ErrorType.USER_ERROR),
    AMBIGUOUS_FUNCTION_CALL(32, ErrorType.USER_ERROR),
    INVALID_SCHEMA_PROPERTY(33, ErrorType.USER_ERROR),
    SCHEMA_NOT_EMPTY(34, ErrorType.USER_ERROR),
    QUERY_TEXT_TOO_LARGE(35, ErrorType.USER_ERROR),
    UNSUPPORTED_SUBQUERY(36, ErrorType.USER_ERROR),
    EXCEEDED_FUNCTION_MEMORY_LIMIT(37, ErrorType.USER_ERROR),
    ADMINISTRATIVELY_KILLED(38, ErrorType.USER_ERROR),
    INVALID_COLUMN_PROPERTY(39, ErrorType.USER_ERROR),
    QUERY_HAS_TOO_MANY_STAGES(40, ErrorType.USER_ERROR),
    INVALID_SPATIAL_PARTITIONING(41, ErrorType.USER_ERROR),
    INVALID_ANALYZE_PROPERTY(42, ErrorType.USER_ERROR),
    GENERATED_BYTECODE_TOO_LARGE(43, ErrorType.USER_ERROR),
    WARNING_AS_ERROR(44, ErrorType.USER_ERROR),
    GENERIC_INTERNAL_ERROR(65536, ErrorType.INTERNAL_ERROR),
    TOO_MANY_REQUESTS_FAILED(65537, ErrorType.INTERNAL_ERROR),
    PAGE_TOO_LARGE(65538, ErrorType.INTERNAL_ERROR),
    PAGE_TRANSPORT_ERROR(65539, ErrorType.INTERNAL_ERROR),
    PAGE_TRANSPORT_TIMEOUT(65540, ErrorType.INTERNAL_ERROR),
    NO_NODES_AVAILABLE(65541, ErrorType.INTERNAL_ERROR),
    REMOTE_TASK_ERROR(65542, ErrorType.INTERNAL_ERROR),
    COMPILER_ERROR(65543, ErrorType.INTERNAL_ERROR),
    REMOTE_TASK_MISMATCH(65544, ErrorType.INTERNAL_ERROR),
    SERVER_SHUTTING_DOWN(65545, ErrorType.INTERNAL_ERROR),
    FUNCTION_IMPLEMENTATION_MISSING(65546, ErrorType.INTERNAL_ERROR),
    REMOTE_BUFFER_CLOSE_FAILED(65547, ErrorType.INTERNAL_ERROR),
    SERVER_STARTING_UP(65548, ErrorType.INTERNAL_ERROR),
    FUNCTION_IMPLEMENTATION_ERROR(65549, ErrorType.INTERNAL_ERROR),
    INVALID_PROCEDURE_DEFINITION(65550, ErrorType.INTERNAL_ERROR),
    PROCEDURE_CALL_FAILED(65551, ErrorType.INTERNAL_ERROR),
    AMBIGUOUS_FUNCTION_IMPLEMENTATION(65552, ErrorType.INTERNAL_ERROR),
    ABANDONED_TASK(65553, ErrorType.INTERNAL_ERROR),
    CORRUPT_SERIALIZED_IDENTITY(65554, ErrorType.INTERNAL_ERROR),
    CORRUPT_PAGE(65555, ErrorType.INTERNAL_ERROR),
    OPTIMIZER_TIMEOUT(65556, ErrorType.INTERNAL_ERROR),
    OUT_OF_SPILL_SPACE(65557, ErrorType.INTERNAL_ERROR),
    REMOTE_HOST_GONE(65558, ErrorType.INTERNAL_ERROR),
    CONFIGURATION_INVALID(65559, ErrorType.INTERNAL_ERROR),
    CONFIGURATION_UNAVAILABLE(65560, ErrorType.INTERNAL_ERROR),
    INVALID_RESOURCE_GROUP(65561, ErrorType.INTERNAL_ERROR),
    GENERIC_RECOVERY_ERROR(65562, ErrorType.INTERNAL_ERROR),
    TOO_MANY_TASK_FAILED(65563, ErrorType.INTERNAL_ERROR),
    INDEX_LOADER_TIMEOUT(65564, ErrorType.INTERNAL_ERROR),
    EXCEEDED_TASK_UPDATE_SIZE_LIMIT(65565, ErrorType.INTERNAL_ERROR),
    NODE_SELECTION_NOT_SUPPORTED(65566, ErrorType.INTERNAL_ERROR),
    SPOOLING_STORAGE_ERROR(65567, ErrorType.INTERNAL_ERROR),
    GENERIC_INSUFFICIENT_RESOURCES(131072, ErrorType.INSUFFICIENT_RESOURCES),
    EXCEEDED_GLOBAL_MEMORY_LIMIT(131073, ErrorType.INSUFFICIENT_RESOURCES),
    QUERY_QUEUE_FULL(131074, ErrorType.INSUFFICIENT_RESOURCES),
    EXCEEDED_TIME_LIMIT(131075, ErrorType.INSUFFICIENT_RESOURCES),
    CLUSTER_OUT_OF_MEMORY(131076, ErrorType.INSUFFICIENT_RESOURCES),
    EXCEEDED_CPU_LIMIT(131077, ErrorType.INSUFFICIENT_RESOURCES),
    EXCEEDED_SPILL_LIMIT(131078, ErrorType.INSUFFICIENT_RESOURCES),
    EXCEEDED_LOCAL_MEMORY_LIMIT(131079, ErrorType.INSUFFICIENT_RESOURCES),
    ADMINISTRATIVELY_PREEMPTED(131080, ErrorType.INSUFFICIENT_RESOURCES),
    EXCEEDED_SCAN_RAW_BYTES_READ_LIMIT(131081, ErrorType.INSUFFICIENT_RESOURCES),
    EXCEEDED_OUTPUT_SIZE_LIMIT(131082, ErrorType.INSUFFICIENT_RESOURCES),
    EXCEEDED_REVOCABLE_MEMORY_LIMIT(131083, ErrorType.INSUFFICIENT_RESOURCES);

    private final ErrorCode errorCode;

    private StandardErrorCode(int code, ErrorType type) {
        this.errorCode = new ErrorCode(code, this.name(), type);
    }

    @Override
    public ErrorCode toErrorCode() {
        return this.errorCode;
    }
}

