/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import java.util.Objects;

public class RuntimeMetric {
    private final String name;
    private long sum;
    private long count;
    private long max = Long.MIN_VALUE;
    private long min = Long.MAX_VALUE;

    public RuntimeMetric(String name) {
        this.name = name;
    }

    public static RuntimeMetric copyOf(RuntimeMetric metric) {
        Objects.requireNonNull(metric, "metric is null");
        return new RuntimeMetric(metric.getName(), metric.getSum(), metric.getCount(), metric.getMax(), metric.getMin());
    }

    @JsonCreator
    public RuntimeMetric(@JsonProperty(value="name") String name, @JsonProperty(value="sum") long sum, @JsonProperty(value="count") long count, @JsonProperty(value="max") long max, @JsonProperty(value="min") long min) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.sum = sum;
        this.count = count;
        this.max = max;
        this.min = min;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    public void addValue(long value) {
        this.sum += value;
        ++this.count;
        this.max = Math.max(this.max, value);
        this.min = Math.min(this.min, value);
    }

    public static RuntimeMetric merge(RuntimeMetric metric1, RuntimeMetric metric2) {
        if (metric1 == null) {
            return metric2;
        }
        if (metric2 == null) {
            return metric1;
        }
        RuntimeMetric mergedMetric = RuntimeMetric.copyOf(metric1);
        mergedMetric.mergeWith(metric2);
        return mergedMetric;
    }

    public void mergeWith(RuntimeMetric metric) {
        if (metric == null) {
            return;
        }
        this.sum += metric.getSum();
        this.count += metric.getCount();
        this.max = Math.max(this.max, metric.getMax());
        this.min = Math.min(this.min, metric.getMin());
    }

    @JsonProperty
    public long getSum() {
        return this.sum;
    }

    @JsonProperty
    public long getCount() {
        return this.count;
    }

    @JsonProperty
    public long getMax() {
        return this.max;
    }

    @JsonProperty
    public long getMin() {
        return this.min;
    }
}

