/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.type.AbstractVarcharType;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;
import com.facebook.presto.jdbc.internal.common.type.TypeSignatureParameter;
import java.util.Collections;

public final class VarcharType
extends AbstractVarcharType {
    public static final VarcharType VARCHAR = new VarcharType(Integer.MAX_VALUE);

    public static VarcharType createUnboundedVarcharType() {
        return VARCHAR;
    }

    public static VarcharType createVarcharType(int length) {
        if (length > 0x7FFFFFFE || length < 0) {
            throw new IllegalArgumentException("Invalid VARCHAR length " + length);
        }
        return new VarcharType(length);
    }

    public static TypeSignature getParametrizedVarcharSignature(String param) {
        return new TypeSignature("varchar", TypeSignatureParameter.of(param));
    }

    private VarcharType(int length) {
        super(length, new TypeSignature("varchar", Collections.singletonList(TypeSignatureParameter.of(length))));
    }
}

