/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.function;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public class FunctionVersion {
    private static final FunctionVersion NOT_VERSIONED = new FunctionVersion(Optional.empty());
    private final Optional<String> version;

    public static FunctionVersion notVersioned() {
        return NOT_VERSIONED;
    }

    public static FunctionVersion withVersion(String version) {
        return new FunctionVersion(Optional.of(version));
    }

    @JsonCreator
    public FunctionVersion(@JsonProperty(value="version") Optional<String> version) {
        this.version = Objects.requireNonNull(version, "version is null");
    }

    @JsonProperty(value="version")
    Optional<String> getVersion() {
        return this.version;
    }

    public boolean hasVersion() {
        return this.version.isPresent();
    }

    public String toString() {
        return this.version.orElse("");
    }
}

