/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.apache.http.protocol;

import com.facebook.presto.jdbc.internal.apache.http.HttpConnection;
import com.facebook.presto.jdbc.internal.apache.http.HttpException;
import com.facebook.presto.jdbc.internal.apache.http.HttpHost;
import com.facebook.presto.jdbc.internal.apache.http.HttpInetConnection;
import com.facebook.presto.jdbc.internal.apache.http.HttpRequest;
import com.facebook.presto.jdbc.internal.apache.http.HttpRequestInterceptor;
import com.facebook.presto.jdbc.internal.apache.http.HttpVersion;
import com.facebook.presto.jdbc.internal.apache.http.ProtocolException;
import com.facebook.presto.jdbc.internal.apache.http.ProtocolVersion;
import com.facebook.presto.jdbc.internal.apache.http.annotation.Contract;
import com.facebook.presto.jdbc.internal.apache.http.annotation.ThreadingBehavior;
import com.facebook.presto.jdbc.internal.apache.http.protocol.HttpContext;
import com.facebook.presto.jdbc.internal.apache.http.protocol.HttpCoreContext;
import com.facebook.presto.jdbc.internal.apache.http.util.Args;
import java.io.IOException;
import java.net.InetAddress;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestTargetHost
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        HttpCoreContext coreContext = HttpCoreContext.adapt(context);
        ProtocolVersion ver = request.getRequestLine().getProtocolVersion();
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT") && ver.lessEquals(HttpVersion.HTTP_1_0)) {
            return;
        }
        if (!request.containsHeader("Host")) {
            HttpHost targetHost = coreContext.getTargetHost();
            if (targetHost == null) {
                HttpConnection conn = coreContext.getConnection();
                if (conn instanceof HttpInetConnection) {
                    InetAddress address = ((HttpInetConnection)conn).getRemoteAddress();
                    int port = ((HttpInetConnection)conn).getRemotePort();
                    if (address != null) {
                        targetHost = new HttpHost(address.getHostName(), port);
                    }
                }
                if (targetHost == null) {
                    if (ver.lessEquals(HttpVersion.HTTP_1_0)) {
                        return;
                    }
                    throw new ProtocolException("Target host missing");
                }
            }
            request.addHeader("Host", targetHost.toHostString());
        }
    }
}

