/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.RowExpression;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Immutable
public final class FilterNode
extends PlanNode {
    private final PlanNode source;
    private final RowExpression predicate;

    @JsonCreator
    public FilterNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="predicate") RowExpression predicate) {
        super(id);
        this.source = source;
        this.predicate = predicate;
    }

    @JsonProperty
    public RowExpression getPredicate() {
        return this.predicate;
    }

    @JsonProperty(value="source")
    public PlanNode getSource() {
        return this.source;
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.source.getOutputVariables();
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.unmodifiableList(Collections.singletonList(this.source));
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitFilter(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        if (newChildren == null || newChildren.size() != 1) {
            throw new IllegalArgumentException("Expect exactly one child to replace");
        }
        return new FilterNode(this.getId(), newChildren.get(0), this.predicate);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FilterNode that = (FilterNode)o;
        return Objects.equals(this.source, that.source) && Objects.equals(this.predicate, that.predicate);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.predicate);
    }
}

