/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.block.ArrayBlock;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.BlockUtil;
import com.facebook.presto.jdbc.internal.common.block.IntArrayList;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.javax.annotation.Nullable;

public abstract class AbstractArrayBlock
implements Block {
    protected abstract Block getRawElementBlock();

    protected abstract int[] getOffsets();

    @Override
    public abstract int getOffsetBase();

    @Nullable
    protected abstract boolean[] getValueIsNull();

    int getOffset(int position) {
        return this.getOffsets()[position + this.getOffsetBase()];
    }

    @Override
    public String getEncodingName() {
        return "ARRAY";
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        int[] newOffsets = new int[length + 1];
        boolean[] newValueIsNull = new boolean[length];
        IntArrayList valuesPositions = new IntArrayList();
        int newPosition = 0;
        for (int i = offset; i < offset + length; ++i) {
            int position = positions[i];
            if (this.isNull(position)) {
                newValueIsNull[newPosition] = true;
                newOffsets[newPosition + 1] = newOffsets[newPosition];
            } else {
                int valuesStartOffset = this.getOffset(position);
                int valuesEndOffset = this.getOffset(position + 1);
                int valuesLength = valuesEndOffset - valuesStartOffset;
                newOffsets[newPosition + 1] = newOffsets[newPosition] + valuesLength;
                for (int elementIndex = valuesStartOffset; elementIndex < valuesEndOffset; ++elementIndex) {
                    valuesPositions.add(elementIndex);
                }
            }
            ++newPosition;
        }
        Block newValues = this.getRawElementBlock().copyPositions(valuesPositions.elements(), 0, valuesPositions.size());
        return ArrayBlock.createArrayBlockInternal(0, length, newValueIsNull, newOffsets, newValues);
    }

    @Override
    public Block getRegion(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        return ArrayBlock.createArrayBlockInternal(position + this.getOffsetBase(), length, this.getValueIsNull(), this.getOffsets(), this.getRawElementBlock());
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int valueStart = this.getOffsets()[this.getOffsetBase() + position];
        int valueEnd = this.getOffsets()[this.getOffsetBase() + position + length];
        return this.getRawElementBlock().getRegionSizeInBytes(valueStart, valueEnd - valueStart) + 5L * (long)length;
    }

    @Override
    public long getRegionLogicalSizeInBytes(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int valueStart = this.getOffsets()[this.getOffsetBase() + position];
        int valueEnd = this.getOffsets()[this.getOffsetBase() + position + length];
        return this.getRawElementBlock().getRegionLogicalSizeInBytes(valueStart, valueEnd - valueStart) + 5L * (long)length;
    }

    @Override
    public long getApproximateRegionLogicalSizeInBytes(int position, int length) {
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int valueStart = this.getOffset(position);
        int valueEnd = this.getOffset(position + length);
        return this.getRawElementBlock().getApproximateRegionLogicalSizeInBytes(valueStart, valueEnd - valueStart) + (long)(5 * length);
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] positions) {
        BlockUtil.checkValidPositions(positions, this.getPositionCount());
        boolean[] used = new boolean[this.getRawElementBlock().getPositionCount()];
        int usedPositionCount = 0;
        for (int i = 0; i < positions.length; ++i) {
            if (!positions[i]) continue;
            ++usedPositionCount;
            int valueStart = this.getOffsets()[this.getOffsetBase() + i];
            int valueEnd = this.getOffsets()[this.getOffsetBase() + i + 1];
            for (int j = valueStart; j < valueEnd; ++j) {
                used[j] = true;
            }
        }
        return this.getRawElementBlock().getPositionsSizeInBytes(used) + 5L * (long)usedPositionCount;
    }

    @Override
    public Block copyRegion(int position, int length) {
        boolean[] newValueIsNull;
        int positionCount = this.getPositionCount();
        BlockUtil.checkValidRegion(positionCount, position, length);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + length);
        Block newValues = this.getRawElementBlock().copyRegion(startValueOffset, endValueOffset - startValueOffset);
        int[] newOffsets = BlockUtil.compactOffsets(this.getOffsets(), position + this.getOffsetBase(), length);
        boolean[] valueIsNull = this.getValueIsNull();
        boolean[] blArray = newValueIsNull = valueIsNull == null ? null : BlockUtil.compactArray(valueIsNull, position + this.getOffsetBase(), length);
        if (newValues == this.getRawElementBlock() && newOffsets == this.getOffsets() && newValueIsNull == valueIsNull) {
            return this;
        }
        return ArrayBlock.createArrayBlockInternal(0, length, newValueIsNull, newOffsets, newValues);
    }

    @Override
    public Block getBlock(int position) {
        this.checkReadablePosition(position);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        return this.getRawElementBlock().getRegion(startValueOffset, endValueOffset - startValueOffset);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        blockBuilder.appendStructureInternal(this, position);
    }

    @Override
    public void writePositionTo(int position, SliceOutput output) {
        if (this.isNull(position)) {
            output.writeByte(0);
        } else {
            int startValueOffset = this.getOffset(position);
            int endValueOffset = this.getOffset(position + 1);
            int numberOfElements = endValueOffset - startValueOffset;
            output.writeByte(1);
            output.writeInt(numberOfElements);
            Block rawElementBlock = this.getRawElementBlock();
            for (int i = startValueOffset; i < endValueOffset; ++i) {
                rawElementBlock.writePositionTo(i, output);
            }
        }
    }

    protected Block getSingleValueBlockInternal(int position) {
        this.checkReadablePosition(position);
        int startValueOffset = this.getOffset(position);
        int valueLength = this.getOffset(position + 1) - startValueOffset;
        Block newValues = this.getRawElementBlock().copyRegion(startValueOffset, valueLength);
        return ArrayBlock.createArrayBlockInternal(0, 1, new boolean[]{this.isNull(position)}, new int[]{0, valueLength}, newValues);
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        this.checkReadablePosition(position);
        if (this.isNull(position)) {
            return 0L;
        }
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        Block rawElementBlock = this.getRawElementBlock();
        long size = 0L;
        for (int i = startValueOffset; i < endValueOffset; ++i) {
            size += rawElementBlock.getEstimatedDataSizeForStats(i);
        }
        return size;
    }

    @Override
    public boolean mayHaveNull() {
        return this.getValueIsNull() != null;
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        boolean[] valueIsNull = this.getValueIsNull();
        return valueIsNull == null ? false : valueIsNull[position + this.getOffsetBase()];
    }

    public <T> T apply(ArrayBlockFunction<T> function, int position) {
        this.checkReadablePosition(position);
        int startValueOffset = this.getOffset(position);
        int endValueOffset = this.getOffset(position + 1);
        return function.apply(this.getRawElementBlock(), startValueOffset, endValueOffset - startValueOffset);
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }

    @Override
    public Block getBlockUnchecked(int internalPosition) {
        int startValueOffset = this.getOffsets()[internalPosition];
        int endValueOffset = this.getOffsets()[internalPosition + 1];
        return this.getRawElementBlock().getRegion(startValueOffset, endValueOffset - startValueOffset);
    }

    @Override
    public boolean isNullUnchecked(int internalPosition) {
        assert (this.mayHaveNull()) : "no nulls present";
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.getValueIsNull()[internalPosition];
    }

    @Override
    public Block appendNull() {
        boolean[] valueIsNull = BlockUtil.appendNullToIsNullArray(this.getValueIsNull(), this.getOffsetBase(), this.getPositionCount());
        int[] offsets = BlockUtil.appendNullToOffsetsArray(this.getOffsets(), this.getOffsetBase(), this.getPositionCount());
        return ArrayBlock.createArrayBlockInternal(this.getOffsetBase(), this.getPositionCount() + 1, valueIsNull, offsets, this.getRawElementBlock());
    }

    public static interface ArrayBlockFunction<T> {
        public T apply(Block var1, int var2, int var3);
    }
}

