/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.function;

import com.facebook.presto.jdbc.internal.common.type.TimeZoneKey;
import java.util.Locale;
import java.util.Objects;

public class SqlFunctionProperties {
    private final boolean parseDecimalLiteralAsDouble;
    private final boolean legacyRowFieldOrdinalAccessEnabled;
    private final boolean legacyTypeCoercionWarningEnabled;
    private final TimeZoneKey timeZoneKey;
    private final boolean legacyTimestamp;
    private final boolean legacyMapSubscript;
    private final long sessionStartTime;
    private final Locale sessionLocale;
    private final String sessionUser;

    private SqlFunctionProperties(boolean parseDecimalLiteralAsDouble, boolean legacyRowFieldOrdinalAccessEnabled, boolean legacyTypeCoercionWarningEnabled, TimeZoneKey timeZoneKey, boolean legacyTimestamp, boolean legacyMapSubscript, long sessionStartTime, Locale sessionLocale, String sessionUser) {
        this.parseDecimalLiteralAsDouble = parseDecimalLiteralAsDouble;
        this.legacyRowFieldOrdinalAccessEnabled = legacyRowFieldOrdinalAccessEnabled;
        this.legacyTypeCoercionWarningEnabled = legacyTypeCoercionWarningEnabled;
        this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
        this.legacyTimestamp = legacyTimestamp;
        this.legacyMapSubscript = legacyMapSubscript;
        this.sessionStartTime = sessionStartTime;
        this.sessionLocale = Objects.requireNonNull(sessionLocale, "sessionLocale is null");
        this.sessionUser = Objects.requireNonNull(sessionUser, "sessionUser is null");
    }

    public boolean isParseDecimalLiteralAsDouble() {
        return this.parseDecimalLiteralAsDouble;
    }

    public boolean isLegacyRowFieldOrdinalAccessEnabled() {
        return this.legacyRowFieldOrdinalAccessEnabled;
    }

    public boolean isLegacyTypeCoercionWarningEnabled() {
        return this.legacyTypeCoercionWarningEnabled;
    }

    public TimeZoneKey getTimeZoneKey() {
        return this.timeZoneKey;
    }

    @Deprecated
    public boolean isLegacyTimestamp() {
        return this.legacyTimestamp;
    }

    public boolean isLegacyMapSubscript() {
        return this.legacyMapSubscript;
    }

    public long getSessionStartTime() {
        return this.sessionStartTime;
    }

    public Locale getSessionLocale() {
        return this.sessionLocale;
    }

    public String getSessionUser() {
        return this.sessionUser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SqlFunctionProperties)) {
            return false;
        }
        SqlFunctionProperties that = (SqlFunctionProperties)o;
        return Objects.equals(this.parseDecimalLiteralAsDouble, that.parseDecimalLiteralAsDouble) && Objects.equals(this.legacyRowFieldOrdinalAccessEnabled, that.legacyRowFieldOrdinalAccessEnabled) && Objects.equals(this.timeZoneKey, that.timeZoneKey) && Objects.equals(this.legacyTimestamp, that.legacyTimestamp) && Objects.equals(this.legacyMapSubscript, that.legacyMapSubscript);
    }

    public int hashCode() {
        return Objects.hash(this.parseDecimalLiteralAsDouble, this.legacyRowFieldOrdinalAccessEnabled, this.timeZoneKey, this.legacyTimestamp, this.legacyMapSubscript);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean parseDecimalLiteralAsDouble;
        private boolean legacyRowFieldOrdinalAccessEnabled;
        private boolean legacyTypeCoercionWarningEnabled;
        private TimeZoneKey timeZoneKey;
        private boolean legacyTimestamp;
        private boolean legacyMapSubscript;
        private long sessionStartTime;
        private Locale sessionLocale;
        private String sessionUser;

        private Builder() {
        }

        public Builder setParseDecimalLiteralAsDouble(boolean parseDecimalLiteralAsDouble) {
            this.parseDecimalLiteralAsDouble = parseDecimalLiteralAsDouble;
            return this;
        }

        public Builder setLegacyRowFieldOrdinalAccessEnabled(boolean legacyRowFieldOrdinalAccessEnabled) {
            this.legacyRowFieldOrdinalAccessEnabled = legacyRowFieldOrdinalAccessEnabled;
            return this;
        }

        public Builder setLegacyTypeCoercionWarningEnabled(boolean legacyTypeCoercionWarningEnabled) {
            this.legacyTypeCoercionWarningEnabled = legacyTypeCoercionWarningEnabled;
            return this;
        }

        public Builder setTimeZoneKey(TimeZoneKey timeZoneKey) {
            this.timeZoneKey = Objects.requireNonNull(timeZoneKey, "timeZoneKey is null");
            return this;
        }

        public Builder setLegacyTimestamp(boolean legacyTimestamp) {
            this.legacyTimestamp = legacyTimestamp;
            return this;
        }

        public Builder setLegacyMapSubscript(boolean legacyMapSubscript) {
            this.legacyMapSubscript = legacyMapSubscript;
            return this;
        }

        public Builder setSessionStartTime(long sessionStartTime) {
            this.sessionStartTime = sessionStartTime;
            return this;
        }

        public Builder setSessionLocale(Locale sessionLocale) {
            this.sessionLocale = sessionLocale;
            return this;
        }

        public Builder setSessionUser(String sessionUser) {
            this.sessionUser = sessionUser;
            return this;
        }

        public SqlFunctionProperties build() {
            return new SqlFunctionProperties(this.parseDecimalLiteralAsDouble, this.legacyRowFieldOrdinalAccessEnabled, this.legacyTypeCoercionWarningEnabled, this.timeZoneKey, this.legacyTimestamp, this.legacyMapSubscript, this.sessionStartTime, this.sessionLocale, this.sessionUser);
        }
    }
}

