/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.array;

import com.facebook.presto.jdbc.internal.common.array.Long2IntOpenHashMap;
import com.facebook.presto.jdbc.internal.common.block.AbstractMapBlock;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.io.airlift.slice.Slice;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import java.lang.reflect.Array;

public final class ReferenceCountMap
extends Long2IntOpenHashMap {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(ReferenceCountMap.class).instanceSize();

    public int incrementAndGet(Object key) {
        return this.addTo(ReferenceCountMap.getHashCode(key), 1) + 1;
    }

    public int decrementAndGet(Object key) {
        long hashCode = ReferenceCountMap.getHashCode(key);
        int previousCount = this.addTo(hashCode, -1);
        if (previousCount == 1) {
            this.remove(hashCode);
        }
        return previousCount - 1;
    }

    public long sizeOf() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf(this.key) + SizeOf.sizeOf(this.value);
    }

    private static long getHashCode(Object key) {
        int extraIdentity;
        if (key == null) {
            extraIdentity = 0;
        } else if (key instanceof Block) {
            extraIdentity = (int)((Block)key).getRetainedSizeInBytes();
        } else if (key instanceof Slice) {
            extraIdentity = (int)((Slice)key).getRetainedSize();
        } else if (key.getClass().isArray()) {
            extraIdentity = Array.getLength(key);
        } else if (key instanceof AbstractMapBlock.HashTables) {
            extraIdentity = (int)((AbstractMapBlock.HashTables)key).getRetainedSizeInBytes();
        } else {
            throw new IllegalArgumentException(String.format("Unsupported type for %s", key));
        }
        return ((long)System.identityHashCode(key) << 32) + (long)extraIdentity;
    }
}

