/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.common.block.LongArrayBlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.UncheckedBlock;
import com.facebook.presto.jdbc.internal.common.function.SqlFunctionProperties;
import com.facebook.presto.jdbc.internal.common.type.DecimalType;
import com.facebook.presto.jdbc.internal.common.type.SqlDecimal;
import java.math.BigInteger;

final class ShortDecimalType
extends DecimalType {
    ShortDecimalType(int precision, int scale) {
        super(precision, scale, Long.TYPE);
        this.validatePrecisionScale(precision, scale, 18);
    }

    @Override
    public int getFixedSize() {
        return 8;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new LongArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / this.getFixedSize()));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, this.getFixedSize());
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new LongArrayBlockBuilder(null, positionCount);
    }

    @Override
    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        long unscaledValue = block.getLong(position);
        return new SqlDecimal(BigInteger.valueOf(unscaledValue), this.getPrecision(), this.getScale());
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        long rightValue;
        long leftValue = leftBlock.getLong(leftPosition);
        return leftValue == (rightValue = rightBlock.getLong(rightPosition));
    }

    @Override
    public long hash(Block block, int position) {
        return block.getLong(position);
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        long leftValue = leftBlock.getLong(leftPosition);
        long rightValue = rightBlock.getLong(rightPosition);
        return Long.compare(leftValue, rightValue);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeLong(block.getLong(position)).closeEntry();
        }
    }

    @Override
    public long getLong(Block block, int position) {
        return block.getLong(position);
    }

    @Override
    public long getLongUnchecked(UncheckedBlock block, int internalPosition) {
        return block.getLongUnchecked(internalPosition);
    }

    @Override
    public void writeLong(BlockBuilder blockBuilder, long value) {
        blockBuilder.writeLong(value).closeEntry();
    }
}

