/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.relation;

import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.predicate.Primitives;
import com.facebook.presto.jdbc.internal.common.predicate.Utils;
import com.facebook.presto.jdbc.internal.common.type.Type;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.relation.RowExpression;
import com.facebook.presto.jdbc.internal.spi.relation.RowExpressionVisitor;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class ConstantExpression
extends RowExpression {
    private final Object value;
    private final Type type;

    public ConstantExpression(Optional<SourceLocation> sourceLocation, Object value, Type type) {
        super(sourceLocation);
        Objects.requireNonNull(type, "type is null");
        if (value != null && !Primitives.wrap(type.getJavaType()).isInstance(value)) {
            throw new IllegalArgumentException(String.format("Object '%s' does not match type %s", value, type.getJavaType()));
        }
        this.value = value;
        this.type = type;
    }

    public ConstantExpression(Object value, Type type) {
        this(Optional.empty(), value, type);
    }

    @JsonCreator
    public static ConstantExpression createConstantExpression(@JsonProperty(value="valueBlock") Block valueBlock, @JsonProperty(value="type") Type type) {
        return new ConstantExpression(Utils.blockToNativeValue(type, valueBlock), type);
    }

    @JsonProperty
    public Block getValueBlock() {
        return Utils.nativeValueToBlock(this.type, this.value);
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    @Override
    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @Override
    public String toString() {
        return String.valueOf(this.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.value, this.type);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ConstantExpression other = (ConstantExpression)obj;
        return Objects.equals(this.value, other.value) && Objects.equals(this.type, other.type);
    }

    @Override
    public <R, C> R accept(RowExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitConstant(this, context);
    }
}

