/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.type;

import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilderStatus;
import com.facebook.presto.jdbc.internal.common.block.ByteArrayBlock;
import com.facebook.presto.jdbc.internal.common.block.ByteArrayBlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.UncheckedBlock;
import com.facebook.presto.jdbc.internal.common.function.SqlFunctionProperties;
import com.facebook.presto.jdbc.internal.common.type.AbstractType;
import com.facebook.presto.jdbc.internal.common.type.FixedWidthType;
import com.facebook.presto.jdbc.internal.common.type.TypeSignature;
import java.util.Optional;

public final class BooleanType
extends AbstractType
implements FixedWidthType {
    public static final BooleanType BOOLEAN = new BooleanType();

    private BooleanType() {
        super(TypeSignature.parseTypeSignature("boolean"), Boolean.TYPE);
    }

    public static Block wrapByteArrayAsBooleanBlockWithoutNulls(byte[] booleansAsBytes) {
        return new ByteArrayBlock(booleansAsBytes.length, Optional.empty(), booleansAsBytes);
    }

    public static Block createBlockForSingleNonNullValue(boolean value) {
        byte byteValue = value ? (byte)1 : 0;
        return new ByteArrayBlock(1, Optional.empty(), new byte[]{byteValue});
    }

    @Override
    public int getFixedSize() {
        return 1;
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries, int expectedBytesPerEntry) {
        int maxBlockSizeInBytes = blockBuilderStatus == null ? 0x100000 : blockBuilderStatus.getMaxPageSizeInBytes();
        return new ByteArrayBlockBuilder(blockBuilderStatus, Math.min(expectedEntries, maxBlockSizeInBytes / 1));
    }

    @Override
    public BlockBuilder createBlockBuilder(BlockBuilderStatus blockBuilderStatus, int expectedEntries) {
        return this.createBlockBuilder(blockBuilderStatus, expectedEntries, 1);
    }

    @Override
    public BlockBuilder createFixedSizeBlockBuilder(int positionCount) {
        return new ByteArrayBlockBuilder(null, positionCount);
    }

    @Override
    public boolean isComparable() {
        return true;
    }

    @Override
    public boolean isOrderable() {
        return true;
    }

    @Override
    public Object getObjectValue(SqlFunctionProperties properties, Block block, int position) {
        if (block.isNull(position)) {
            return null;
        }
        return block.getByte(position) != 0;
    }

    @Override
    public boolean equalTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        boolean leftValue = leftBlock.getByte(leftPosition) != 0;
        boolean rightValue = rightBlock.getByte(rightPosition) != 0;
        return leftValue == rightValue;
    }

    @Override
    public long hash(Block block, int position) {
        boolean value = block.getByte(position) != 0;
        return value ? 1231L : 1237L;
    }

    @Override
    public int compareTo(Block leftBlock, int leftPosition, Block rightBlock, int rightPosition) {
        boolean leftValue = leftBlock.getByte(leftPosition) != 0;
        boolean rightValue = rightBlock.getByte(rightPosition) != 0;
        return Boolean.compare(leftValue, rightValue);
    }

    @Override
    public void appendTo(Block block, int position, BlockBuilder blockBuilder) {
        if (block.isNull(position)) {
            blockBuilder.appendNull();
        } else {
            blockBuilder.writeByte(block.getByte(position)).closeEntry();
        }
    }

    @Override
    public boolean getBoolean(Block block, int position) {
        return block.getByte(position) != 0;
    }

    @Override
    public boolean getBooleanUnchecked(UncheckedBlock block, int internalPosition) {
        return block.getByteUnchecked(internalPosition) != 0;
    }

    @Override
    public void writeBoolean(BlockBuilder blockBuilder, boolean value) {
        blockBuilder.writeByte(value ? 1 : 0).closeEntry();
    }

    @Override
    public boolean equals(Object other) {
        return other == BOOLEAN;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode();
    }
}

