/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.jackson.dataformat.smile;

import com.facebook.presto.jdbc.internal.jackson.core.TSFBuilder;
import com.facebook.presto.jdbc.internal.jackson.dataformat.smile.SmileFactory;
import com.facebook.presto.jdbc.internal.jackson.dataformat.smile.SmileGenerator;
import com.facebook.presto.jdbc.internal.jackson.dataformat.smile.SmileParser;

public class SmileFactoryBuilder
extends TSFBuilder<SmileFactory, SmileFactoryBuilder> {
    protected int _formatParserFeatures;
    protected int _formatGeneratorFeatures;

    protected SmileFactoryBuilder() {
        this._formatParserFeatures = SmileFactory.DEFAULT_SMILE_PARSER_FEATURE_FLAGS;
        this._formatGeneratorFeatures = SmileFactory.DEFAULT_SMILE_GENERATOR_FEATURE_FLAGS;
    }

    public SmileFactoryBuilder(SmileFactory base) {
        super(base);
        this._formatParserFeatures = base._smileParserFeatures;
        this._formatGeneratorFeatures = base._smileGeneratorFeatures;
    }

    public SmileFactoryBuilder enable(SmileParser.Feature f) {
        this._formatParserFeatures |= f.getMask();
        return (SmileFactoryBuilder)this._this();
    }

    public SmileFactoryBuilder enable(SmileParser.Feature first, SmileParser.Feature ... other) {
        this._formatParserFeatures |= first.getMask();
        for (SmileParser.Feature f : other) {
            this._formatParserFeatures |= f.getMask();
        }
        return (SmileFactoryBuilder)this._this();
    }

    public SmileFactoryBuilder disable(SmileParser.Feature f) {
        this._formatParserFeatures &= ~f.getMask();
        return (SmileFactoryBuilder)this._this();
    }

    public SmileFactoryBuilder disable(SmileParser.Feature first, SmileParser.Feature ... other) {
        this._formatParserFeatures &= ~first.getMask();
        for (SmileParser.Feature f : other) {
            this._formatParserFeatures &= ~f.getMask();
        }
        return (SmileFactoryBuilder)this._this();
    }

    public SmileFactoryBuilder configure(SmileParser.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public SmileFactoryBuilder enable(SmileGenerator.Feature f) {
        this._formatGeneratorFeatures |= f.getMask();
        return (SmileFactoryBuilder)this._this();
    }

    public SmileFactoryBuilder enable(SmileGenerator.Feature first, SmileGenerator.Feature ... other) {
        this._formatGeneratorFeatures |= first.getMask();
        for (SmileGenerator.Feature f : other) {
            this._formatGeneratorFeatures |= f.getMask();
        }
        return (SmileFactoryBuilder)this._this();
    }

    public SmileFactoryBuilder disable(SmileGenerator.Feature f) {
        this._formatGeneratorFeatures &= ~f.getMask();
        return (SmileFactoryBuilder)this._this();
    }

    public SmileFactoryBuilder disable(SmileGenerator.Feature first, SmileGenerator.Feature ... other) {
        this._formatGeneratorFeatures &= ~first.getMask();
        for (SmileGenerator.Feature f : other) {
            this._formatGeneratorFeatures &= ~f.getMask();
        }
        return (SmileFactoryBuilder)this._this();
    }

    public SmileFactoryBuilder configure(SmileGenerator.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public int formatParserFeaturesMask() {
        return this._formatParserFeatures;
    }

    public int formatGeneratorFeaturesMask() {
        return this._formatGeneratorFeatures;
    }

    @Override
    public SmileFactory build() {
        return new SmileFactory(this);
    }
}

