/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.common.block;

import com.facebook.presto.jdbc.internal.common.array.Arrays;
import com.facebook.presto.jdbc.internal.common.block.Block;
import com.facebook.presto.jdbc.internal.common.block.BlockBuilder;
import com.facebook.presto.jdbc.internal.common.block.BlockUtil;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SizeOf;
import com.facebook.presto.jdbc.internal.io.airlift.slice.SliceOutput;
import com.facebook.presto.jdbc.internal.javax.annotation.Nullable;
import com.facebook.presto.jdbc.internal.jol.info.ClassLayout;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.BiConsumer;

public class LongArrayBlock
implements Block {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(LongArrayBlock.class).instanceSize();
    public static final int SIZE_IN_BYTES_PER_POSITION = 9;
    private final int arrayOffset;
    private final int positionCount;
    @Nullable
    private final boolean[] valueIsNull;
    private final long[] values;
    private final long retainedSizeInBytes;

    public LongArrayBlock(int positionCount, Optional<boolean[]> valueIsNull, long[] values) {
        this(0, positionCount, valueIsNull.orElse(null), values);
    }

    LongArrayBlock(int arrayOffset, int positionCount, boolean[] valueIsNull, long[] values) {
        if (arrayOffset < 0) {
            throw new IllegalArgumentException("arrayOffset is negative");
        }
        this.arrayOffset = arrayOffset;
        if (positionCount < 0) {
            throw new IllegalArgumentException("positionCount is negative");
        }
        this.positionCount = positionCount;
        if (values.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("values length is less than positionCount");
        }
        this.values = values;
        if (valueIsNull != null && valueIsNull.length - arrayOffset < positionCount) {
            throw new IllegalArgumentException("isNull length is less than positionCount");
        }
        this.valueIsNull = valueIsNull;
        this.retainedSizeInBytes = (long)INSTANCE_SIZE + SizeOf.sizeOf(valueIsNull) + SizeOf.sizeOf(values);
    }

    @Override
    public long getSizeInBytes() {
        return 9L * (long)this.positionCount;
    }

    @Override
    public OptionalInt fixedSizeInBytesPerPosition() {
        return OptionalInt.of(9);
    }

    @Override
    public long getRegionSizeInBytes(int position, int length) {
        return 9L * (long)length;
    }

    @Override
    public long getPositionsSizeInBytes(boolean[] usedPositions, int usedPositionCount) {
        return 9L * (long)usedPositionCount;
    }

    @Override
    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    @Override
    public long getEstimatedDataSizeForStats(int position) {
        return this.isNull(position) ? 0L : 8L;
    }

    @Override
    public void retainedBytesForEachPart(BiConsumer<Object, Long> consumer) {
        consumer.accept(this.values, SizeOf.sizeOf(this.values));
        if (this.valueIsNull != null) {
            consumer.accept(this.valueIsNull, SizeOf.sizeOf(this.valueIsNull));
        }
        consumer.accept(this, Long.valueOf(INSTANCE_SIZE));
    }

    @Override
    public int getPositionCount() {
        return this.positionCount;
    }

    @Override
    public long getLong(int position) {
        this.checkReadablePosition(position);
        return this.getLongUnchecked(position + this.arrayOffset);
    }

    @Override
    @Deprecated
    public int getInt(int position) {
        this.checkReadablePosition(position);
        return Math.toIntExact(this.values[position + this.arrayOffset]);
    }

    @Override
    @Deprecated
    public short getShort(int position) {
        this.checkReadablePosition(position);
        short value = (short)this.values[position + this.arrayOffset];
        if ((long)value != this.values[position + this.arrayOffset]) {
            throw new ArithmeticException("short overflow");
        }
        return value;
    }

    @Override
    @Deprecated
    public byte getByte(int position) {
        this.checkReadablePosition(position);
        byte value = (byte)this.values[position + this.arrayOffset];
        if ((long)value != this.values[position + this.arrayOffset]) {
            throw new ArithmeticException("byte overflow");
        }
        return value;
    }

    @Override
    public boolean mayHaveNull() {
        return this.valueIsNull != null;
    }

    @Override
    public boolean isNull(int position) {
        this.checkReadablePosition(position);
        return this.valueIsNull != null && this.isNullUnchecked(position + this.arrayOffset);
    }

    @Override
    public void writePositionTo(int position, BlockBuilder blockBuilder) {
        this.checkReadablePosition(position);
        blockBuilder.writeLong(this.values[position + this.arrayOffset]);
        blockBuilder.closeEntry();
    }

    @Override
    public void writePositionTo(int position, SliceOutput output) {
        if (this.isNull(position)) {
            output.writeByte(0);
        } else {
            output.writeByte(1);
            output.writeLong(this.values[position + this.arrayOffset]);
        }
    }

    @Override
    public Block getSingleValueBlock(int position) {
        boolean[] blArray;
        this.checkReadablePosition(position);
        if (this.isNull(position)) {
            boolean[] blArray2 = new boolean[1];
            blArray = blArray2;
            blArray2[0] = true;
        } else {
            blArray = null;
        }
        return new LongArrayBlock(0, 1, blArray, new long[]{this.values[position + this.arrayOffset]});
    }

    @Override
    public Block copyPositions(int[] positions, int offset, int length) {
        BlockUtil.checkArrayRange(positions, offset, length);
        boolean[] newValueIsNull = null;
        if (this.valueIsNull != null) {
            newValueIsNull = new boolean[length];
        }
        long[] newValues = new long[length];
        for (int i = 0; i < length; ++i) {
            int position = positions[offset + i];
            this.checkReadablePosition(position);
            if (this.valueIsNull != null) {
                newValueIsNull[i] = this.valueIsNull[position + this.arrayOffset];
            }
            newValues[i] = this.values[position + this.arrayOffset];
        }
        return new LongArrayBlock(0, length, newValueIsNull, newValues);
    }

    @Override
    public Block getRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        return new LongArrayBlock(positionOffset + this.arrayOffset, length, this.valueIsNull, this.values);
    }

    @Override
    public Block copyRegion(int positionOffset, int length) {
        BlockUtil.checkValidRegion(this.getPositionCount(), positionOffset, length);
        boolean[] newValueIsNull = this.valueIsNull == null ? null : BlockUtil.compactArray(this.valueIsNull, positionOffset += this.arrayOffset, length);
        long[] newValues = BlockUtil.compactArray(this.values, positionOffset, length);
        if (newValueIsNull == this.valueIsNull && newValues == this.values) {
            return this;
        }
        return new LongArrayBlock(0, length, newValueIsNull, newValues);
    }

    @Override
    public String getEncodingName() {
        return "LONG_ARRAY";
    }

    public String toString() {
        return String.format("LongArrayBlock(%d){positionCount=%d}", this.hashCode(), this.getPositionCount());
    }

    private void checkReadablePosition(int position) {
        if (position < 0 || position >= this.getPositionCount()) {
            throw new IllegalArgumentException("position is not valid");
        }
    }

    @Override
    public int getOffsetBase() {
        return this.arrayOffset;
    }

    @Override
    public boolean isNullUnchecked(int internalPosition) {
        assert (this.mayHaveNull()) : "no nulls present";
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.valueIsNull[internalPosition];
    }

    @Override
    public long getLongUnchecked(int internalPosition) {
        assert (BlockUtil.internalPositionInRange(internalPosition, this.getOffsetBase(), this.getPositionCount()));
        return this.values[internalPosition];
    }

    @Override
    public Block appendNull() {
        boolean[] newValueIsNull = BlockUtil.appendNullToIsNullArray(this.valueIsNull, this.arrayOffset, this.positionCount);
        long[] newValues = Arrays.ensureCapacity(this.values, this.arrayOffset + this.positionCount + 1, Arrays.ExpansionFactor.SMALL, Arrays.ExpansionOption.PRESERVE);
        return new LongArrayBlock(this.arrayOffset, this.positionCount + 1, newValueIsNull, newValues);
    }
}

