/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.ErrorCodeSupplier;
import com.facebook.presto.jdbc.internal.spi.PrestoException;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.StandardErrorCode;
import com.facebook.presto.jdbc.internal.spi.plan.LogicalProperties;
import com.facebook.presto.jdbc.internal.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class LimitNode
extends PlanNode {
    private final PlanNode source;
    private final long count;
    private final Step step;

    @JsonCreator
    public LimitNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="count") long count, @JsonProperty(value="step") Step step) {
        super(sourceLocation, id);
        LimitNode.checkCondition(count >= 0L, StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "count must be greater than or equal to zero");
        this.source = Objects.requireNonNull(source, "source is null");
        this.count = count;
        this.step = Objects.requireNonNull(step, "step is null");
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.singletonList(this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public long getCount() {
        return this.count;
    }

    @JsonProperty
    public Step getStep() {
        return this.step;
    }

    public boolean isPartial() {
        return this.step == Step.PARTIAL;
    }

    @Override
    public LogicalProperties computeLogicalProperties(LogicalPropertiesProvider logicalPropertiesProvider) {
        Objects.requireNonNull(logicalPropertiesProvider, "logicalPropertiesProvider cannot be null.");
        return logicalPropertiesProvider.getLimitProperties(this);
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.source.getOutputVariables();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitLimit(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        LimitNode.checkCondition(newChildren != null && newChildren.size() == 1, StandardErrorCode.GENERIC_INTERNAL_ERROR, "Expect exactly 1 child PlanNode");
        return new LimitNode(this.getSourceLocation(), this.getId(), newChildren.get(0), this.count, this.getStep());
    }

    private static void checkCondition(boolean condition, ErrorCodeSupplier errorCode, String message) {
        if (!condition) {
            throw new PrestoException(errorCode, message);
        }
    }

    public static enum Step {
        PARTIAL,
        FINAL;

    }
}

