/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonTypeInfo;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.plan.LogicalProperties;
import com.facebook.presto.jdbc.internal.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@JsonTypeInfo(use=JsonTypeInfo.Id.MINIMAL_CLASS, property="@type")
public abstract class PlanNode {
    private final Optional<SourceLocation> sourceLocation;
    private final PlanNodeId id;

    protected PlanNode(Optional<SourceLocation> sourceLocation, PlanNodeId id) {
        this.sourceLocation = sourceLocation;
        Objects.requireNonNull(id, "id is null");
        this.id = id;
    }

    @JsonProperty(value="id")
    public PlanNodeId getId() {
        return this.id;
    }

    @JsonProperty(value="sourceLocation")
    public Optional<SourceLocation> getSourceLocation() {
        return this.sourceLocation;
    }

    public abstract List<PlanNode> getSources();

    public LogicalProperties computeLogicalProperties(LogicalPropertiesProvider logicalPropertiesProvider) {
        Objects.requireNonNull(logicalPropertiesProvider, "logicalPropertiesProvider cannot be null.");
        return logicalPropertiesProvider.getDefaultProperties();
    }

    public abstract List<VariableReferenceExpression> getOutputVariables();

    public abstract PlanNode replaceChildren(List<PlanNode> var1);

    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitPlan(this, context);
    }
}

