/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.javax.annotation.concurrent.Immutable;
import com.facebook.presto.jdbc.internal.spi.SourceLocation;
import com.facebook.presto.jdbc.internal.spi.plan.Assignments;
import com.facebook.presto.jdbc.internal.spi.plan.LogicalProperties;
import com.facebook.presto.jdbc.internal.spi.plan.LogicalPropertiesProvider;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import com.facebook.presto.jdbc.internal.spi.plan.PlanNodeId;
import com.facebook.presto.jdbc.internal.spi.plan.PlanVisitor;
import com.facebook.presto.jdbc.internal.spi.relation.VariableReferenceExpression;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

@Immutable
public final class ProjectNode
extends PlanNode {
    private final PlanNode source;
    private final Assignments assignments;
    private final Locality locality;

    public ProjectNode(PlanNodeId id, PlanNode source, Assignments assignments) {
        this(source.getSourceLocation(), id, source, assignments, Locality.UNKNOWN);
    }

    @JsonCreator
    public ProjectNode(Optional<SourceLocation> sourceLocation, @JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="source") PlanNode source, @JsonProperty(value="assignments") Assignments assignments, @JsonProperty(value="locality") Locality locality) {
        super(sourceLocation, id);
        Objects.requireNonNull(source, "source is null");
        Objects.requireNonNull(assignments, "assignments is null");
        Objects.requireNonNull(locality, "locality is null");
        this.source = source;
        this.assignments = assignments;
        this.locality = locality;
    }

    @Override
    public List<VariableReferenceExpression> getOutputVariables() {
        return this.assignments.getOutputs();
    }

    @JsonProperty
    public Assignments getAssignments() {
        return this.assignments;
    }

    @Override
    public List<PlanNode> getSources() {
        return Collections.singletonList(this.source);
    }

    @JsonProperty
    public PlanNode getSource() {
        return this.source;
    }

    @JsonProperty
    public Locality getLocality() {
        return this.locality;
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitProject(this, context);
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Objects.requireNonNull(newChildren, "newChildren list is null");
        if (newChildren.size() != 1) {
            throw new IllegalArgumentException("newChildren list has multiple items");
        }
        return new ProjectNode(this.getSourceLocation(), this.getId(), newChildren.get(0), this.assignments, this.locality);
    }

    @Override
    public LogicalProperties computeLogicalProperties(LogicalPropertiesProvider logicalPropertiesProvider) {
        Objects.requireNonNull(logicalPropertiesProvider, "logicalPropertiesProvider cannot be null.");
        return logicalPropertiesProvider.getProjectProperties(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ProjectNode that = (ProjectNode)o;
        return Objects.equals(this.source, that.source) && Objects.equals(this.assignments, that.assignments) && this.locality == that.locality;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.source, this.assignments, this.locality});
    }

    public static enum Locality {
        UNKNOWN,
        LOCAL,
        REMOTE;

    }
}

