/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.plan;

import com.facebook.presto.jdbc.internal.spi.plan.PlanNode;
import java.util.Objects;
import java.util.Optional;

public class PlanNodeWithHash {
    private final PlanNode planNode;
    private final Optional<String> hash;

    public PlanNodeWithHash(PlanNode planNode, Optional<String> hash) {
        this.planNode = Objects.requireNonNull(planNode, "planNode is null");
        this.hash = Objects.requireNonNull(hash, "hash is null");
    }

    public PlanNode getPlanNode() {
        return this.planNode;
    }

    public Optional<String> getHash() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlanNodeWithHash that = (PlanNodeWithHash)o;
        return Objects.equals(this.planNode, that.planNode) && Objects.equals(this.hash, that.hash);
    }

    public int hashCode() {
        return Objects.hash(this.planNode, this.hash);
    }

    public String toString() {
        return String.format("plan: %s, hash: %s", this.planNode, this.hash);
    }
}

