/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi.statistics;

import com.facebook.presto.jdbc.internal.spi.statistics.Estimate;
import java.util.Objects;

public class PlanStatistics {
    private static final PlanStatistics EMPTY = new PlanStatistics(Estimate.unknown(), Estimate.unknown(), 0.0);
    private final Estimate rowCount;
    private final Estimate outputSize;
    private final double confidence;

    public static PlanStatistics empty() {
        return EMPTY;
    }

    public PlanStatistics(Estimate rowCount, Estimate outputSize, double confidence) {
        this.rowCount = Objects.requireNonNull(rowCount, "rowCount can not be null");
        this.outputSize = Objects.requireNonNull(outputSize, "rowCount can not be null");
        PlanStatistics.checkArgument(confidence >= 0.0 && confidence <= 1.0, "confidence should be between 0 and 1");
        this.confidence = confidence;
    }

    public Estimate getRowCount() {
        return this.rowCount;
    }

    public Estimate getOutputSize() {
        return this.outputSize;
    }

    public double getConfidence() {
        return this.confidence;
    }

    private static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }
}

