/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.jdbc.internal.spi;

import com.facebook.presto.jdbc.internal.common.predicate.TupleDomain;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonCreator;
import com.facebook.presto.jdbc.internal.jackson.annotation.JsonProperty;
import com.facebook.presto.jdbc.internal.spi.ColumnHandle;
import java.util.Objects;
import java.util.Optional;

public class SplitContext {
    public static final SplitContext NON_CACHEABLE = new SplitContext(false);
    private final boolean cacheable;
    private final Optional<TupleDomain<ColumnHandle>> dynamicFilterPredicate;

    @JsonCreator
    public SplitContext(@JsonProperty boolean cacheable) {
        this(cacheable, Optional.empty());
    }

    public SplitContext(boolean cacheable, TupleDomain<ColumnHandle> dynamicFilterPredicate) {
        this(cacheable, Optional.of(Objects.requireNonNull(dynamicFilterPredicate, "dynamicFilterPredicate is null")));
    }

    private SplitContext(boolean cacheable, Optional<TupleDomain<ColumnHandle>> dynamicFilterPredicate) {
        this.cacheable = cacheable;
        this.dynamicFilterPredicate = dynamicFilterPredicate;
    }

    @JsonProperty
    public boolean isCacheable() {
        return this.cacheable;
    }

    public Optional<TupleDomain<ColumnHandle>> getDynamicFilterPredicate() {
        return this.dynamicFilterPredicate;
    }
}

